/*
 * fea_histogram.cpp
 *
 *  Created on: 16 May 2011
 *      Author: torsten
 */

#include "fea_histogram.h"
#include <vector>
#include <utility>
#include <string>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <assert.h>
#include <math.h>

#ifdef DEBUG_FEA_HISTOGRAM
extern
void	fea_histogram_log	(char*);
static
char	log_txt	[1024];
#define	LOG_FEA_HISTOGRAM(s) sprintf(log_txt,s); \
								fea_histogram_log(log_txt);
#define	LOG_FEA_HISTOGRAM_2(s,t) sprintf(log_txt,s,t); \
							fea_histogram_log(log_txt);
#define	LOG_FEA_HISTOGRAM_3(s,t,u) sprintf(log_txt,s,t,u); \
							fea_histogram_log(log_txt);
#define	LOG_FEA_HISTOGRAM_4(s,t,u,v) sprintf(log_txt,s,t,u,v); \
							fea_histogram_log(log_txt);
#define	LOG_FEA_HISTOGRAM_5(s,t,u,v,w) sprintf(log_txt,s,t,u,v,w); \
							fea_histogram_log(log_txt);
#else

#define	LOG_FEA_HISTOGRAM(s)
#define	LOG_FEA_HISTOGRAM_2(s,t)
#define	LOG_FEA_HISTOGRAM_3(s,t,u)
#define	LOG_FEA_HISTOGRAM_4(s,t,u,v)
#define	LOG_FEA_HISTOGRAM_5(s,t,u,v,w)

#endif // DEBUG_FEA_HISTOGRAM

namespace Features	{

Histogram::Histogram():m_Name()
{   }

bool
Histogram::BuildUp(const std::string& filename) {

	u_int64_t no(0), absvals_bin(0);
	float bin(0.0), weight_bin(0.0);
	std::pair<double,double> p;
	FILE* f(NULL);
	struct stat buf;
	int ret(0);
	m_Name = filename;
	m_Hist.clear();

	LOG_FEA_HISTOGRAM_2("his> %s",filename.c_str())
	if(stat(filename.c_str(),&buf) == 0) {
		f = fopen(filename.c_str(),"r");
		if(f != NULL) {
			while(!feof(f) && ret != EOF) {
				ret = fscanf(f,"%u %f %lu %e",(unsigned int*)&no,&bin,&absvals_bin,&weight_bin);
				if(ret != EOF && ret != 0) {
					p.first = bin;
					p.second = weight_bin;
					m_Hist.push_back(p);
#ifdef DEBUG_FEA_HISTOGRAM
					LOG_FEA_HISTOGRAM_5("%u\t%.5f\t%u\t %.15f",(unsigned int)no,p.first,(unsigned int)absvals_bin,p.second);
#endif // DEBUG_FEA_HISTOGRAM
				}
			}
		}
		fclose(f);
	}
	return (m_Hist.size() != 0);
}

void
Histogram::Print() const {
	std::vector<std::pair<double,double> >::const_iterator it(m_Hist.begin());
	LOG_FEA_HISTOGRAM_2("%s",Name().c_str())
	while(it != m_Hist.end()) {
#ifdef DEBUG_FEA_HISTOGRAM
		LOG_FEA_HISTOGRAM_4("%u\t%f\t%e",(unsigned int)(it-m_Hist.begin()),(*it).first,(*it).second);
#endif // DEBUG_FEA_HISTOGRAM
		it++;
	}
}

Histogram::~Histogram()
{ }

const std::string&
Histogram::Name() const
{ return m_Name; }

double
Histogram::GetProb(double val) const {
	size_t bin(0);
	return GetProb(val,bin);
}

/*
 * GetProb	-	computes convex combination of bin neighbours
 * 				accordingly MS slides #25/26
 * \param	-	reference value
 * \param [out]
 * 			-	bin within value showed up
 * \return	-	probability of input value	*/
double
Histogram::GetProb(double val, size_t& bin) const {
	bool found(false);
	double lambda(0.0), ret(0.0);
	std::pair<double,double> prev;
	std::vector<std::pair<double,double> >::const_iterator it(m_Hist.begin());
	prev = *it;
	bin = 0;

	if(val < prev.first)
		val = prev.first;
	/* value MUST be \ge than first bin bound
	 * */

	++it;
	while(!found && it != m_Hist.end()) {
		found = (val < (*it).first);
		if(!found) {
			prev = *it;
			++it;
		}
	}

	/*piecewise linear approximation (convex combination of bin neighbours)
	 * 									*/
	if(found) {
#ifdef FEA_NO_CONVEX_COMBINATION
		lambda = 0.;
#else
		lambda = (val - prev.first) / ((*it).first - prev.first);
#endif // FEA_NO_CONVEX_COMBINATION
		ret = (1.0  - lambda) * prev.second + lambda * (*it).second;
	} else
	/* value larger than last bin bound	*/
		ret = prev.second;

	bin = it - m_Hist.begin() - 1;
	return ret;
}

} // Features
