/*
 * fea_histogram.h
 *
 *  Created on: 16 May 2011
 *      Author: torsten
 */

#ifndef FEA_HISTOGRAM_H_
#define FEA_HISTOGRAM_H_

#ifndef _GLIBCXX_VECTOR
#include <vector>
#endif // _GLIBCXX_VECTOR

#ifndef _GLIBCXX_STRING
#include <string>
#endif // _GLIBCXX_STRING

#ifndef _GLIBCXX_UTILITY
#include <utility>
#endif // _GLIBCXX_UTILITY

namespace 	Features		{

	enum	Feature	{
		RASA_CONSERV_Val_COMMON_Scale			=	100,

		RASA_Threshold_ForBeing_NonIF_scaled	=	15,
		RASA_Threshold_ForBeing_labelled_Gt		=   10,

		CONSERV_Threshold_TakenInto_Account_Le	=   95
	};

class Histogram		{
	std::vector<std::pair<double,double> >
						m_Hist;

	std::string			m_Name;

private:
	Histogram& operator=(const Histogram&);

	Histogram(const Histogram&);

public:
						Histogram			();

						~Histogram			();

			/*	BuildUp	-	Reads from input filename
			 * 				and builds up histogram structure
			 * */
			bool		BuildUp				(const std::string&);

			/* Computes Probability of given value
			 * \param	val			-	input value
			 * \param [out]			-	bin within value showed up
			 * \return	probability	-	output probability
			 * */
			double		GetProb				(double val, size_t& bin)	const;

			/* Computes Probability of given value
			 * \param	val			-	input value
			 * \return	probability	-	output probability
			 * */
			double		GetProb				(double val) 				const;

			void		Print				()							const;

			const std::string&
						Name				()							const;

			size_t		Size				()
			{	return m_Hist.size();				}
};

} // Features;

#endif	/* FEA_HISTOGRAM_H_ */
