#include "log.h"
#include <sys/types.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <string>
#include <unistd.h>

static
Log the_logger;

bool
Log::m_Verbose                  =   false,
Log::m_Gui_Active               =   false,
Log::m_Log_NewPcl               =   false,
Log::m_HasInit                  =   false;

std::string
Log::m_LogDir;

size_t
Log::m_LogFile_limit			=	(300 * 1024 * 1024);

LogPair
Log::s_LogPairs             []  =      {
    { NULL    ,   "mrf_utils.log"   		,   "/tmp/mrf_utils.log",	0	,	0   ,	0   },
    { NULL    ,   "mrf_setup.log"   		,   "/tmp/mrf_setup.log",	0	,	0   ,	0   },
    { NULL    ,   "fea_hist.log"   			,	"/tmp/fea_hist.log",	0	,	0	,	0   },
    { NULL    ,   "train_utils.log"			,	"/tmp/train_utils.log",	0	,	0   ,	0   },
    { NULL    ,   "train_labelling.log"		,	"/tmp/train_labelling.log",	0,	0	,	0   }
};

Log*
Log::get()  {
    return &the_logger;
}

void
Log::init_logs(const char* logdir) {
	std::string s;
    if(!logdir)
    	logdir = "./";
	m_LogDir.assign(logdir,strlen(logdir));
	m_HasInit = true;
    LogPair* p = s_LogPairs;
    while(p < s_LogPairs + sizeof(s_LogPairs) / sizeof(LogPair)) {
        if(p->m_Name != NULL) {
        	s.assign(logdir);
        	s += "/";
        	s += p->m_Name;
            p->m_Str = fopen(s.c_str(),"w+");
            if(p->m_Str == NULL) {
                perror(p->m_Name);
                m_HasInit = false;
            }
        }
        if(m_Gui_Active && p->m_Pipe_Name != NULL)
            p->m_Pipe = /* mkfifo */ 0;
        p++;
    }
}

void
Log::end_logs() {
	if(m_HasInit) {
		LogPair* p = s_LogPairs;
		while(p < s_LogPairs + sizeof(s_LogPairs) / sizeof(LogPair)) {
	/*        if(p->m_Pipe != INVALID_HANDLE_VALUE)
				CloseHandle(p->m_Pipe);*/
			fclose(p->m_Str);
			p++;
		}
	    m_HasInit = false;
	}
}

bool
Log::Invoke_LogFile_Archiving(u_int32_t n) {
	bool ret(false);
	std::string zip("gzip -fN "), mv("mv "), name_nr, nm, dir(m_LogDir + "/");
	char b[64], cwd [1024];

	getcwd(cwd, sizeof(cwd));
	chdir(dir.c_str());
	fflush(s_LogPairs[n].m_Str);
	fclose(s_LogPairs[n].m_Str);

	sprintf(b,".%lu",++s_LogPairs[n].m_Gzip_File);
	name_nr.append(s_LogPairs[n].m_Name,strlen(s_LogPairs[n].m_Name));
	name_nr.append(b,strlen(b));
	mv.append(s_LogPairs[n].m_Name,strlen(s_LogPairs[n].m_Name));
	mv.append(" ",1);
	mv.append(name_nr);
	zip.append(name_nr);

	ret = (system(mv.c_str()) == 0 && system(zip.c_str()) == 0);
	s_LogPairs[n].m_Str = fopen(s_LogPairs[n].m_Name,"w+");
	ret = (ret && s_LogPairs[n].m_Str != NULL);
	return (!chdir(cwd) && ret);
}

void
Log::logout(char* str, u_int32_t n) {
	bool log_full(false);
	if(m_HasInit) {
		if(s_LogPairs[n].m_Name != NULL) {
			s_LogPairs[n].m_Bytes_Written += strlen(str);
			if(s_LogPairs[n].m_Bytes_Written > m_LogFile_limit) {
				if(Invoke_LogFile_Archiving(n))
					s_LogPairs[n].m_Bytes_Written = strlen(str);
				else
					log_full = true;
			}
			if(!log_full) {
				if(m_Log_NewPcl)
					fprintf(s_LogPairs[n].m_Str,"%ld|%s\n",time(NULL),str);
				else
					fprintf(s_LogPairs[n].m_Str,"%s\n",str);
				fflush(s_LogPairs[n].m_Str);
			} else
				fprintf(stderr,"log-full>%s",s_LogPairs[n].m_Name);
		}
		if(m_Gui_Active && s_LogPairs[n].m_Pipe_Name != NULL)
			transmit_cmd(str,s_LogPairs[n].m_Pipe);
	}
}

void
Log::print_comm_error(bool force) {
    if(force || m_Verbose) {
        //fprintf(stderr,"%s\n",msg);
    }
}

void
Log::transmit_cmd(char* str, int pipe) {
/*    unsigned long ret = 0;
    std::string cstr(str);
    cstr.append("\r");
    if(pipe != INVALID_HANDLE_VALUE)
        WriteFile(pipe,cstr.c_str(),cstr.length(),&ret,NULL);
    else
        print_comm_error(true);
    print_comm_error(ret != cstr.length());
    FlushFileBuffers(pipe);*/
}

void
logout(char* str, u_int32_t n) {
    Log::get()->logout(str,n);
}

bool
Log_Is_GuiActive() {
    return Log::get()->Log_Is_GuiActive();
}

/** Logging Side                            */

extern
void    logout      (char*, u_int32_t);

extern
bool    Log_Is_GuiActive
                    ();

#define IDLE_TIME_AFTER_CONN_UM 200

void
mrf_utils_log(char* str) {
    logout(str,0);
/*    if(Log_Is_GuiActive())
    	usleep(IDLE_TIME_AFTER_CONN_UM,false);*/
}

void
giesling_log(char* str) {
    logout(str,1);
/*    if(Log_Is_GuiActive())
    	usleep(IDLE_TIME_AFTER_CONN_UM,false);*/
}

void
fea_histogram_log(char* str) {
	logout(str,2);
}

void
train_utils_log(char* str) {
	logout(str,3);
}

void
train_labelling_log(char* str) {
	logout(str,4);
}
// eof
