#ifndef LOG_H
#define LOG_H

#ifndef _INC_STDIO
#include <stdio.h>
#endif // _INC_STDIO

#ifndef _SYS_TYPES_H
#include <sys/types.h>
#endif // _SYS_TYPES_H

#ifndef _GLIBCXX_STRING
#include <string>
#endif // _GLIBCXX_STRING

struct  LogPair                  {
    FILE*   		m_Str;
    const char*   	m_Name;
    const char*   	m_Pipe_Name;
    int32_t			m_Pipe;
    size_t			m_Bytes_Written;
    size_t			m_Gzip_File;
};

class  Log                     {
private:
	static
	std::string m_LogDir;

    static
    bool    	m_Verbose, m_Gui_Active, m_Log_NewPcl, m_HasInit;

    /*	maximum log file size to invoke	log file archiving
     *
     */
    static
    size_t		m_LogFile_limit;

    static
    LogPair 	s_LogPairs      [];

public:
    static
    Log*    	get             ();

    void    	init_logs       (const char* logdir=NULL);

    void    	end_logs        ();

    void    	logout          (char* str,u_int32_t n);

    bool		Log_Is_GuiActive()
    {    return m_Gui_Active;				}

private:
    bool		Invoke_LogFile_Archiving
    							(u_int32_t n);

    void    	print_comm_error(bool force);

    void    	transmit_cmd    (char* str, int32_t);
};

#endif // LOG_H
