/*
 * 	train_eval.h
 *
 *  Created on: May 8th, 2012
 *      Author: torsten
 */

#ifndef TRAIN_EVAL_H_
#define TRAIN_EVAL_H_

#ifndef TRAIN_TYPES_H_
#include "train_types.h"
#endif // TRAIN_TYPES_H_

#ifndef GRAPH_TYPES_H_
#include <graph_types.h>
#endif // GRAPH_TYPES_H_

namespace 	std { using namespace __gnu_cxx; }

namespace	dai	{
	class FactorGraph;
}

namespace	Training	{

	class	Eval	{

		static
		const double
				m_MinResults_Diff,
				m_MinResults_Slope;

		static
		double	m_ROCset_FPR, m_ROCset_TPR;

		static
		size_t	m_False_Negative, m_False_Positive,
				m_True_Negative, m_True_Positive,
				m_FN_obj, m_FP_obj,
				m_TN_obj, m_TP_obj,
				m_FN_opt, m_FP_opt,
				m_TN_opt, m_TP_opt;

		static
		double	m_Prec_opt, m_Recall_opt, m_F1_opt, m_Acc_opt, m_CC_opt,
				m_Prec_obj, m_Recall_obj, m_F1_obj, m_Acc_obj, m_CC_obj,
				m_Prec_0_opt, m_Recall_0_opt, m_F1_0_opt,
				m_Prec_0_obj, m_Recall_0_obj, m_F1_0_obj,
				m_TPrate_opt, m_FPrate_opt;

		public:

		static
		void		FullInit			();

		static
		void		Init_ForObject		(size_t no_nodes);

		static
		void		SaveBestParams		(size_t at_learn_step);

		static
		void		EvalMAPLabelling	(const std::vector<GraphGen::Node<Types::Node> >& nodes);

		static
		size_t 		state				(Types::Node::RefLabel label);

		static Types::Node::RefLabel
					state				(size_t label);

		static
		void		StatsPerObject		();

		static
		void		StatsValidation		();

		static
		void		Save_FactorGraph	();

		static
		void		Make_Reference_Labelling
										(const std::vector<GraphGen::Node<Types::Node> >& nodes);

		static
		bool		ComputeFunctional_ROCdiff
										();
		static
		bool		ComputeFunctional_ROCcurve
										();
		static
		bool		ComputeFunctional_ROCset_1
										();
		static
		bool		ComputeFunctional_ROCset_2
										();
		static
		void		Save_Runs_BestWeightVectors
										(const std::vector<double>& w_q, const std::vector<double>& w_g);

		static
		void		Save_WeightVectors	(bool final, bool new_chunk, const std::vector<double>& w_q, const std::vector<double>& w_g);

		static
		void		Log_ClassifierResults
										();

		static
		double		Score				(const std::vector<size_t>& statevec);

		static
		void		SetOpt_Functional_ROCset
										(double fpr, double tpr) {
			m_ROCset_FPR = fpr;
			m_ROCset_TPR = tpr;
		}
	};
};

#endif // TRAIN_EVAL_H_
