/*
 * 	train_labelling.h
 *
 *  Created on: June 8th, 2011
 *      Author: torsten
 */

#ifndef TRAIN_LABELLING_H_
#define TRAIN_LABELLING_H_

#ifndef TRAIN_TYPES_H_
#include "train_types.h"
#endif // TRAIN_TYPES_H_

#ifndef FEA_HISTOGRAM_H_
#include <fea/fea_histogram.h>
#endif // FEA_HISTOGRAM_H_

#ifndef _GLIBCXX_VECTOR
#include <vector>
#endif // _GLIBCXX_VECTOR

#ifndef _GLIBCXX_STRING
#include <string>
#endif // _GLIBCXX_STRING

#ifndef __defined_libdai_factor_h
#include <dai/factor.h>
#endif // __defined_libdai_factor_h

namespace 	std { using namespace __gnu_cxx; }

namespace	dai	{
	class FactorGraph;
}

namespace	Training	{

	class	Classifier	{

		enum	LearnParameters	{
			LEARN_CHUNKS_DEFAULT	=	100,
			LEARN_STEPS_PER_SAMPLE	=	30,
			LEARN_MAX_CONSECUTE_EQ_DIFFS
									=	100,
			CONSEC_NegDiffs_Forcing_Sampling
									=	1,
			DO_RANDOM_STEP			=	5
		};

		enum	WeightOffset	{
			WeightOffset_If			=	0,
			WeightOffset_NoIf		=	1,
		};

		enum	AddingFeatures	{
			Discretizing			=	16
		};

	private:
		static
		Features::Histogram 		if_pssm, noif_pssm, noif_rasa, if_rasa, noif_conserv, if_conserv, noif_epros, if_epros, noif_rg, if_rg, noif_fe, if_fe;

		static
		std::vector<dai::Factor>	m_Factors;

		static
		dai::FactorGraph*			m_Fg;

		static
		bool						m_Hists_Initialized, m_Verbose, m_MoreVerbose, m_Run_InLogDomain, m_Fg_Needs_Update;

		static
		size_t						m_Nr_Nodes, m_Nr_Edges, m_LearnStep, m_Overall_LearnStep;

		/*	Configuration Learning
		 *
		 */

		/*	Number of un/equal label pairs within current reference labelling
		 */
		/*
		 * edge model parameters: default alpha 0 .56, beta 0.52
		 */
		static
		double						m_INITAL_EDGE_WEIGHT_BETA_g_ij,
									m_INITAL_EDGE_WEIGHT_ALPHA_g_ii;

		static
		bool						m_Opt_EdgeModel_UserSupplied,
									m_Opt_No_EdgeModel_Learning;

		static
		double
									m_Initial_g_ii, m_Initial_g_ij,
									m_Curr_g_ii, m_Curr_g_ij;
		static
		std::vector<double>			m_Initial_V, m_Curr_V, m_Diff;

		static
		double						m_SumFeat_Slot_Width;

		static
		const
		std::vector<GraphGen::Node<Types::Node>*>*
									m_Calpha_backbone;

		static
		size_t						m_Min_node_id, m_Max_node_id;

		/*	number of consecutive negative differences while learning
		 */
		static
		size_t						m_Consec_NegDiffs, m_Consec_ErrClassifierRuns;


		/* Weight vector for edge weights, initial edge weights
		 */
		static
		std::vector<double>			m_W_g, m_Prv_W_g, m_Curr_W_g, m_Initial_g;

		/* Configuration Weight vector for nodes weights, initial nodes weights etc.
		 */
		static
		std::vector<double>			m_W_q, m_Prv_W_q, m_Curr_W_q;

		static
		std::vector<size_t>			m_Ref_Labelling;

		static
		std::vector<size_t>			m_MAP_Nodes;

		static
		size_t						m_Structural_Diff_BigL, m_Prev_Structural_Diff_BigL;

		static
		size_t						m_TP_ref, m_TN_ref, m_FP_curr, m_FN_curr;

		static
		double						m_FP_Scale, m_FN_Scale;

		static
		std::string					m_Output_Obj, m_Output_Dir;

		/* Configuration chunks Learning
		 *
		 */
		static
		std::vector<std::vector<double>	>
									m_W_g_chunk;

		static
		std::vector<std::vector<double>	>
									m_W_q_chunk;

		static
		size_t						m_Opt_MaxNrLearnSteps_PerSample,
									m_Opt_Chunk_Size, m_Opt_LearnRound_PerInput;

		static
		bool						m_Opt_Functional_ROCcurve, m_Opt_Functional_ROCset_1, m_Opt_Functional_ROCset_2, m_Opt_Functional_ROCdiff;

		static
		double						m_Prev_Diff_Map;

		static
		bool						m_Opt_Output_Per_Object;

		static
		bool						m_Opt_Use_ConservExt, m_Opt_Use_RASAext, m_Opt_Use_PssmExt, m_Opt_Use_Epros, m_Opt_BinFeatures,
									m_Opt_Fe, m_Opt_Rg, m_Opt_Rg_CfgData, m_Opt_Using_Exp_EnergyTerm, m_Opt_InferWithGibbs, m_SetWeightZero_iff_Negative;

		static
		size_t						m_Opt_Imm_Rslts;

	public:
		/* ExecLearning	-	executes classifier's learning algorithm
		 * \para s		-	working directory as string
		 * \param nodes
		 * \param edges
		 * \param cptr	-	pointers to C\alpha backbone
		 * \param		-	min and max node ids
		 * \return		-	TRUE, successful learning on parameter example
		 * 					FALSE otherwise
		 */
		static
		bool		ExecLearning		(const std::string& s,
											std::vector<GraphGen::Node<Types::Node> >& nodes,
											const std::vector<Types::Edge>& edges,
											const std::vector<GraphGen::Node<Types::Node>*>& c_alpha_backbone,
											size_t min_node_id, size_t max_node_id);

		static
		void		Post_Learning		();

		/* ExecValidation	-	executes classifier's validation algorithm
		 * \para s		-	working directory as string
		 * \param nodes
		 * \param edges
		 * \param cptr	-	pointers to C\alpha backbone
		 * \param		-	min and max node ids
		 * \return		-	TRUE, successful validation on parameter example
		 * 					FALSE otherwise
		 */
		static
		bool		ExecValidation		(const std::string&,
											std::vector<GraphGen::Node<Types::Node> >& nodes,
											const std::vector<Types::Edge>& edges,
											const std::vector<GraphGen::Node<Types::Node>*>& c_alpha_backbone,
											size_t min_node_id, size_t max_node_id);

		static
		bool		GenerateModelGraphs	(const std::string& indir,
											std::vector<GraphGen::Node<Types::Node> >& nodes,
											const std::vector<Types::Edge>& edges,
											const std::vector<GraphGen::Node<Types::Node>*>& c_alpha_backbone,
											size_t min_node_id, size_t max_node_id);

		static
		void		Purge				();

		static
		bool		Verbose				()			{
			return m_Verbose;
		}

		static
		void		SetVerbose			(bool v)	{
			m_Verbose = v;
		}

		static
		bool		MoreVerbose			()			{
			return m_MoreVerbose;
		}

		static
		void		SetMoreVerbose		(bool v)	{
			m_MoreVerbose = v;
		}

		static
		bool		Run_InLogDomain		()			{
			return m_Run_InLogDomain;
		}

		static
		void		SetRun_InLogDomain	(bool v)	{
			m_Run_InLogDomain = v;
		}

		static
		void		SetIntermediates	(const size_t no_immediates) {
			m_Opt_Imm_Rslts = no_immediates;
		}

		static
		void		Set_Output_Object	(const std::string&);

		static
		void		Save_WeightVectors	(bool final=false, bool new_chk=false);

		static
		void		Set_OutputPerObject	() {
			m_Opt_Output_Per_Object = true;
		}

		static
		void		SetMaxLearnStepsPerSample
										(size_t n) {
			m_Opt_MaxNrLearnSteps_PerSample = n;
		}

		static
		void		SetChunkSize		(size_t n) {
			m_Opt_Chunk_Size = n;
		}

		static
		void		Set_Output_Dir		(const std::string&);

		static
		void		StatsValidation		();

		static
		void		SetTuned_Weights	(const std::vector<double>& w_g, const std::vector<double>& w_q) {
			m_W_g = w_g;
			m_W_q = w_q;
		}

		static
		void		SetOpt_FP_Scale_inOLM
										(double scale_fp);

		static
		void		SetOpt_FN_Scale_inOLM
										(double scale_fn);

		static
		void			SetOpt_LearnFunctional_ROCcurve
										(bool f) {
			m_Opt_Functional_ROCcurve = true;
			m_Opt_Functional_ROCdiff = false;
			m_Opt_Functional_ROCset_1 = false;
			m_Opt_Functional_ROCset_2 = false;
		}

		static
		void			SetOpt_LearnFunctional_ROCdiff
										(bool f) {
			m_Opt_Functional_ROCcurve = false;
			m_Opt_Functional_ROCdiff = true;
			m_Opt_Functional_ROCset_1 = false;
			m_Opt_Functional_ROCset_2 = false;
		}

		static
		void			SetOpt_LearnFunctional_ROCset_1
										(double fpr, double tpr);

		static
		void			SetOpt_LearnFunctional_ROCset_2
										(double fpr, double tpr);

		static
		void			SetEdgeModel	(double alpha  = Training::Types::Edge::EdgeModel__gii,
											double beta = Training::Types::Edge::EdgeModel__gij);

		static
		void			SetNoLearnEdgeModel(bool w) {
			m_Opt_No_EdgeModel_Learning = w;
		}

		static
		void			SetOpt_ConservExt(bool opt) {
			m_Opt_Use_ConservExt =	opt;
		}

		static
		void			SetOpt_Rg		(bool opt) {
			m_Opt_Rg =	opt;
		}

		static
		void			SetOpt_Fe		(bool opt) {
			m_Opt_Fe =	opt;
		}

		static
		void			SetOpt_Rg_CfgData(bool opt)	{
			m_Opt_Rg_CfgData = opt;
		}

		static
		void			SetOpt_Using_Exp_EnergyTerm
										(bool opt) {
			m_Opt_Using_Exp_EnergyTerm =	opt;
		}

		static
		void			SetOpt_BinFeatures
										(bool opt) {
			m_Opt_BinFeatures =	opt;
		}

		static
		void			SetOpt_RASAext	(bool opt) {
			m_Opt_Use_RASAext	=	opt;
		}

		static
		void			SetOpt_Epros	(bool opt) {
			m_Opt_Use_Epros		=	opt;
		}

		static
		void			SetOpt_PssmExt	(bool opt) {
			m_Opt_Use_PssmExt	=	opt;
		}

		static
		void			SetOpt_InferWithGibbs
										(bool o) {
			m_Opt_InferWithGibbs = o;
		}

		static
		void			SetOpt_SetWeightZero_iff_Negative
										(bool o) {
			m_SetWeightZero_iff_Negative = o;
		}

		static
		void			SetLearnRounds_PerInput
										(size_t n)
		{ m_Opt_LearnRound_PerInput = n;			}


		static
		u_int64_t		GetMaxLearnStepsPerSample
										() 			{
			return m_Opt_MaxNrLearnSteps_PerSample;
		}

		static
		u_int64_t		GetChunkSize	()			{
			return m_Opt_Chunk_Size;
		}

		static
		u_int64_t		GetLearnRounds_PerInput
										()			{
			return m_Opt_LearnRound_PerInput;
		}

		static
		bool			GetOpt_Imm_Rslts() 			{
			return m_Opt_Imm_Rslts;
		}

		static
		bool			GetOpt_Output_Per_Object
										()			{
			return m_Opt_Output_Per_Object;
		}

		static
		std::vector<size_t>&
						Get_MAP_Nodes	()			{
			return m_MAP_Nodes;
		}

		static
		std::vector<size_t>&
						Get_Ref_Labelling()			{
			return m_Ref_Labelling;
		}

		static
		size_t			Get_Nr_Nodes	()			{
			return m_Nr_Nodes;
		}

		static
		dai::FactorGraph*
						Get_Fg			()			{
			return m_Fg;
		}

		static
		std::string&	Get_Output_Obj	()			{
			return m_Output_Obj;
		}

		static
		std::string&	Get_Output_Dir	()			{
			return m_Output_Dir;
		}

		static
		size_t			Get_Overall_LearnStep
										()			{
			return m_Overall_LearnStep;
		}

		static
		size_t			Get_LearnStep()				{
			return	m_LearnStep;
		}

	private:
		static
		void		Init				(const std::string&, const bool init_for_learning = true);

		static
		void		CleanUp				();

		static
		bool		RunClassifiers		(const std::vector<GraphGen::Node<Types::Node> >& nodes, const std::vector<Types::Edge>& edges, double& map_score, bool force_sampling=false);

		static
		bool 		RunMPM				(const std::vector<GraphGen::Node<Types::Node> >& nodes, const std::vector<Types::Edge>& edges);

		static
		void		CommonClassifiers_Setup
										(const std::vector<GraphGen::Node<Types::Node> >& nodes);

		static
		bool		LearnStepComputations(const std::vector<GraphGen::Node<Types::Node> >& nodes, const std::vector<Types::Edge>& edges, double S_curr_x_w, double S_x_w);

		static
		bool		MakeInitialMRF		(std::vector<GraphGen::Node<Types::Node> >& nodes, const std::vector<Types::Edge>& edges);

		static
		bool		Learn				(const std::vector<GraphGen::Node<Types::Node> >& nodes, const std::vector<Types::Edge>& edges);

		static
		bool		LearnStep			(const std::vector<GraphGen::Node<Types::Node> >& nodes, const std::vector<Types::Edge>& edges);

		static
		bool		Compute_Differences	(const std::vector<GraphGen::Node<Types::Node> >& nodes, const std::vector<Types::Edge>& edges);

		static
		void		MakeNodesQ			(double& q_l0, double& q_l1, const GraphGen::Node<Types::Node>& n);

		static
		void		MakeEdgeG			(double& g_ii, double& g_ij);

		static
		size_t		index				(size_t bin, Types::Node::StateBinFeature feature);

		static
		void		ComputeMAPmanually	(const std::vector<GraphGen::Node<Types::Node> >& nodes);

		static
		void		Make_ChunkWeights	();

		static
		void		SaveBestParams		(double diffmap);

		static
		bool		ConfigOpt_ConservExt()	{
			return m_Opt_Use_ConservExt;
		}

		static
		bool		ConfigOpt_RASAext	()	{
			return m_Opt_Use_RASAext;
		}

		static
		bool		ConfigOpt_PssmExt	()	{
			return m_Opt_Use_PssmExt;
		}

		static
		bool		ConfigOpt_Rg		()	{
			return m_Opt_Rg;
		}

		static
		bool		ConfigOpt_Fe		()	{
			return m_Opt_Fe;
		}

		static
		bool		ConfigOpt_Epros		()	{
			return m_Opt_Use_Epros;
		}

		static
		bool		ConfigOpt_Rg_CfgData()	{
			return m_Opt_Rg_CfgData;
		}

		static
		bool		ConfigOpt_BinFeatures
										()	{
			return m_Opt_BinFeatures;
		}

		static
		bool		ConfigOpt_Using_Exp_EnergyTerm
										()	{
			return m_Opt_Using_Exp_EnergyTerm;
		}

		static
		bool		ConfigOpt_InferWithGibbs
										()	{
			return m_Opt_InferWithGibbs;
		}

		static
		bool		ConfigOpt_SetWeightZero_iff_Negative
										()	{
			return m_SetWeightZero_iff_Negative;
		}

		static
		void		UpdateFactors		(const std::vector<GraphGen::Node<Types::Node> >& nodes);

		static
		bool 		Compute_Original_Li_Features
										(std::vector<GraphGen::Node<Types::Node> >& nodes);

		static
		void		DoRandomStep		();
	};

}	// namespace Training

#endif // TRAIN_LABELLING_H_

