/*****************************************************************************
 ** Dateiname:    DBGff.cc
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Ausgabe der Ergebnisse im gff-Format
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 17.2.2003  | Oliver Schoeffmann      | Erzeugung der Datei
 ** 2.3.2003   | Oliver Schoeffmann      | e-Wert mit in Ausgabe genommen
 ** 15.6.2003  | Oliver Schoeffmann      | Bezeichner mit in Ausgabe genommen
 ** 10.05.2004 | Mario Stanke            | fixed bug: output splice sites inconsistent
 *****************************************************************************/

#include <cstdio>
#include <fstream>
#include <cstring>

#include <DBGff.hh>
using namespace std;


// Konstruktor

DBGff::DBGff() {
  offset=0;
}


// Destruktor
DBGff::~DBGff() {
}

// Methode: write
//
// Beschreibung: s. Headerdatei

void DBGff::write(DBMatch_t *pm, 
		  ostream &ofstrm, 
		  const char *seqname,
		  const char sourceChar) {
    feature_t akt_feature;
    char groupname[256], id[64];
    int counter = 0, namepos = 0, pipepos = 0;

    // Alle Ergebnisse werden nach Komplexen goerdnet ausgegeben
    for (DBMatch_t *ppm = pm; ppm; ppm = ppm->next) {
	DBParts_t *pp = ppm->parts;
	if (!pp)
	    continue;
	char trend;

	// Aus dem Bezeichner der Sequenz, die das Ergebnis verursacht hat,
	// wird die Acession-Number extrahiert.
	for (namepos = pipepos = 0; ppm->name[namepos] != '\0';
	     namepos++) {
	  /* Normalerweise sieht ppm->name so aus:
	   * ref|XP_341740.1| similar to ORF2 ...
	   * Manchmal aber so:
	   * pir||B34087 hypothetical protein...
	   * Deshalb zhle bis zum 2. | oder Leerzeichen, ein doppeltes '||' zhlt aber nur einfach.
	   */
	  if ((ppm->name[namepos] == '|' && (namepos==0 || ppm->name[namepos-1] != '|' )) || (ppm->name[namepos] == ' '))
	    pipepos++;
	  if (pipepos == 2)
	    break;
	}
	if (pipepos != 2)
	  id[0] = '\0';
	else {
	  if (namepos > 63)
	    namepos = 63;
	  strncpy(id, ppm->name, namepos);
	  id[namepos] = '\0';
	}

	counter++;
	sprintf(groupname, "group%03d %s", counter, id);
	akt_feature = exonpart;

	// Die Vorgehensweise ist unterschiedlich, wenn die Orientierung
	// unterschiedlich ist.
	// Die exonparts, deren Orientierung unbekannt ist, werden beim Vorwaertsstrang
	// mit ausgegeben: strand=.

	// Gegenstrang
	if (ppm->trend < 0) {
	    trend = '-';
	    if (pp->end)
		akt_feature = stop;
	    if (pp->dss)
		akt_feature = dss;
	    while (pp) {
		ofstrm << seqname << "\tAGRIPPA\t" 
		       << features[akt_feature] << "\t";
		switch (akt_feature) {
		  case start:
		   ofstrm << (offset + pp->qry_to - 2) << "\t" 
			  << (offset + pp->qry_to) << "\t" << pp->e_value << "\t"
			  << trend << "\t" << 0;
		   pp = pp->next;
		   break;
		  case exon:
		  case exonpart:
		   ofstrm << (offset + pp->qry_from) << "\t"
			  << (offset + pp->qry_to) << "\t" << pp->e_value << "\t"
			  << trend << "\t";
		   if (pp->frame >= 0)
		     ofstrm << pp->frame;
		   else 
		     ofstrm << ".";
		   if (pp->next || pp->ass)
		       akt_feature = ass;
		   else 
		       if (pp->start)
			   akt_feature = start;
		       else
			   pp = pp->next;
		   break;
		  case dss:
		   ofstrm << (offset + pp->qry_from - 1) << "\t" 
			  << (offset + pp->qry_from -1) << "\t" << pp->e_value << "\t"
			  << trend << "\t.";
		   if (pp->next || pp->start || pp->ass)
		       akt_feature = exon;
		   else
		       akt_feature = exonpart;
		   break;
		  case intron:
		   if (!pp->next)
		       break;
		   ofstrm << (offset + pp->qry_to + 1) << "\t"
			  << (offset + pp->next->qry_from -1) << "\t" << 0
			  << "\t" << trend << "\t.";
		   akt_feature = dss;
		   pp = pp->next;
		   break;
		  case ass:
		   ofstrm << (offset + pp->qry_to + 1) << "\t"
			  << (offset + pp->qry_to + 1) << "\t" << pp->e_value << "\t"
			  << trend << "\t.";
		   if (pp->next)
		       akt_feature = intron;
		   else
		       pp = pp->next;
		   break;
		  case stop:
		   ofstrm << (offset + pp->qry_from) << "\t" 
			  << (offset + pp->qry_from + 2) << "\t" << pp->e_value << "\t"
			  << trend << "\t" << 0;
		   if (pp->next || pp->start || pp->ass)
		       akt_feature = exon;
		   else
		       akt_feature = exonpart;
		   break;
		}
		ofstrm << "\t" << groupname;
		ofstrm << " source=" << sourceChar << endl;
	    } // while(pp) - trend = '-'
	} else {
	  if (ppm->trend > 0) 
	    trend = '+'; // Vorwaertsstrang
	  else
	    trend = '.';
	    if (pp->start)
		akt_feature = start;
	    if (pp->ass)
		akt_feature = ass;
	    while (pp) {
		ofstrm << seqname << "\tAGRIPPA\t" 
		       << features[akt_feature] << "\t";
		switch (akt_feature) {
		  case start:
		   ofstrm << (offset + pp->qry_from) << "\t" 
			  << (offset + pp->qry_from + 2) << "\t" << pp->e_value << "\t"
			  << trend << "\t" << 0;
		   if (pp->next || pp->end)
		       akt_feature = exon;
		   else
		       akt_feature = exonpart;
		   break;
		  case exon:
		  case exonpart:
		   ofstrm << (offset + pp->qry_from) << "\t" 
			  << (offset + pp->qry_to) << "\t" << pp->e_value << "\t"
			  << trend << "\t";
		   if (pp->frame >= 0)
		     ofstrm << pp->frame;
		   else 
		     ofstrm << ".";
		   if (pp->next || pp->dss)
		       akt_feature = dss;
		   else
		       if (pp->end)
			   akt_feature = stop;
		       else
			   pp = pp->next;
		   break;
		  case dss:
		   ofstrm << (offset + pp->qry_to + 1) << "\t" 
			  << (offset + pp->qry_to + 1) << "\t" << pp->e_value << "\t"
			  << trend << "\t.";
		   if (pp->next)
		       akt_feature = intron;
		   else
		       pp = pp->next;
		   break;
		  case intron:
		   if (!pp->next)
		       break;
		   ofstrm << (offset + pp->qry_to + 1) << "\t" 
			  << (offset + pp->next->qry_from - 1) << "\t" << 0
			  << "\t" << trend << "\t.";
		   akt_feature = ass;
		   pp = pp->next;
		   break;
		  case ass:
		   ofstrm << (offset + pp->qry_from - 1) << "\t" 
			  << (offset + pp->qry_from - 1) << "\t" << pp->e_value << "\t"
			  << trend << "\t.";
		   if (pp->next || pp->end || pp->dss)
		       akt_feature = exon;
		   else
		       akt_feature = exonpart;
		   break;
		  case stop:
		   ofstrm << (offset + pp->qry_to - 2) << "\t" 
			  << (offset + pp->qry_to) << "\t" << pp->e_value << "\t"
			  << trend << "\t" << 0;
		   pp = pp->next;
		   break;
		}
		ofstrm << "\t" << groupname;
		ofstrm << " source=" << sourceChar << endl;
	    }// while (pp) - trend = '+'
	} // if (ppm->trend < 0) .. else ...
    } // for (PMatch_t *pp = pm; ...
} // DBGff::write
