/*****************************************************************************
 ** Dateiname:    DBGff.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Ausgabe der Ergebnisse im gff-Format
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 17.2.2002  | Oliver Schoeffmann      | Erzeugung der Datei
 ** 28.04.2004 | Mario Stanke            | Hinzufuegen der Quelle
 ** 10.05.2004 | Mario Stanke            | fixed bug: output splice sites inconsistent
 *****************************************************************************/

#ifndef __dbgff_hh__
#define __dbgff_hh__

#include <string>
#include <fstream>

#include <DBError.hh>
#include <DBMatch.hh>  // fuer PMatch_t
using namespace std;

// In den folgenden beiden Variablen kann die Ausgabe von DBGff festgelegt
// werden. Das bezieht sich nur auf die 3. Spalte (Features)

enum feature_t { start = 0, exon, exonpart, dss, intron, ass, stop };

static const char *features[stop + 1] = { "start", "exon", "exonpart", "dss", 
					  "intron", "ass", "stop" };

// Klasse: DBGff
//
// Sie bietet die Moeglichkeit die Ergebnisse im gff-Format auszugeben.

class DBGff {
public:

    // Konstruktor

    DBGff();

    // Destruktor

    ~DBGff();

    // Methode: write
    //
    // Beschreibung: Gibt die Ergebnisse auf dem uebergebenen Ausgabemedium aus
    //
    // Parameter: 'pm'         - Ergebnissliste
    //            'ofstrm'     - Ausgabestream
    //            'seqname'    - Name der Sequenz, die in der Ausgabe erscheint
    //            'sourceChar' - Bezeicher der Quelle: P(rotein), C(ombined), E(ST)
    //
    // Die Start- und Endposition bei den Splicesites ist jeweils die Randposition
    // des Introns.
    void write(DBMatch_t *pm,
	       ostream &ofstrm,
	       const char *seqname,
	       const char sourceChar);

  int offset;
}; // class DBGff

#endif
