/*****************************************************************************
 ** Dateiname:    DBMatch.cc
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Bietet Strukturen, die intern die Datenbanktreffer verwalten
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 28.9.2002  | Oliver Schoeffmann      | Erzeugung der Datei
 ** 12.1.2003  | Oliver Schoeffmann      | Hinzufuegen der copy-Funktionen
 ** 12.4.2003  | Oliver Schoeffmann      | Ergaenzen der Eintraege, um Sequenz-
 **                                      | abschnitte aufzunehmen. 
 ** 23.04.2004 | Mario Stanke            | Ausgabemethoden von DBMatch_t und DBParts_t
 *****************************************************************************/

#include <cstring>

#include <DBMatch.hh>


///////////////////////////////////////////////////////////////////////////////
// Methoden zu DBParts_t
///////////////////////////////////////////////////////////////////////////////

// Konstruktor
//
// Einige der Variablen muessen Startwerte haben

DBParts_t::DBParts_t() {
    start = end = ass = dss = false;
    akt_pos = qry_from = sbj_from = 0;
    next = 0;
}

//---------------------------------------------------------------------------//

// Destruktor
//
// Loesche den Nachfolger

DBParts_t::~DBParts_t() {
    delete next;
}

//---------------------------------------------------------------------------//


// Methode: swap
//
// Beschreibung: s. Headerdatei

void DBParts_t::swap() {
    long tmp = qry_from;
    qry_from = qry_to;
    qry_to = tmp;
    tmp = sbj_from;
    sbj_from = sbj_to;
    sbj_to = tmp;
    int length = hitline.length();
    for (int i = length - 1; i >= 0; i--) {
	hitline += hitline[i];
	query += query[i];
	subject += subject[i];
    }
    hitline.erase(0, length);
    query.erase(0, length);
    subject.erase(0, length);
}

//---------------------------------------------------------------------------//

// Methode: copy
//
// Beschreibung: s. Headerdatei

DBParts_t *DBParts_t::copy() throw (DBMatchError) {
    DBParts_t *ret = new DBParts_t;
    if (!ret)
	throw DBMatchError("DBParts_t::copy: Speicherfehler");
    ret->frame = frame;
    ret->qry_from = qry_from;
    ret->qry_to = qry_to;
    ret->sbj_from = sbj_from;
    ret->sbj_to = sbj_to;
    ret->start = start;
    ret->end = end;
    ret->length = length;
    ret->score = score;
    ret->akt_id = akt_id;
    ret->akt_pos = akt_pos;
    ret->e_value = e_value;
    ret->ass = ass;
    ret->dss = dss;
    ret->query.assign(query);
    ret->subject.assign(subject);
    ret->hitline.assign(hitline);
    return ret;
}    

//---------------------------------------------------------------------------//

// Methode: copy_all
//
// Beschreibung: s. Headerdatei

DBParts_t *DBParts_t::copy_all() throw (DBMatchError) {
    DBParts_t *ret = copy();
    if (next)
	ret->next = next->copy_all();
    return ret;
}

// Methode: operator<< 
//
// Beschreibung: s. Headerdatei

ostream& operator<< ( ostream& out, DBParts_t& part){
  out << "qry_from= " << part.qry_from << ", qry_to= " << part.qry_to << endl << flush;
  out << "sbj_from= " << part.sbj_from << ", sbj_to= " << part.sbj_to << endl << flush;
  out << "length= " << part.length << ", score= " << part.score 
      << ", akt_id=" << part.akt_id << ", akt_pos=" << part.akt_pos << endl << flush;
  out << "e-value=" << part.e_value << endl << flush;
  out << "frame= " << part.frame << endl << flush;
  out << part.query << endl << part.hitline << endl << part.subject << endl << flush;
  return out;
}



///////////////////////////////////////////////////////////////////////////////
// Methoden von DBMatch_t
///////////////////////////////////////////////////////////////////////////////

// Konstruktor
// 
// Einige Variablen benoetigen Startwerte

DBMatch_t::DBMatch_t() {
    parts = 0;
    next = 0;
    trend = 0;
    wholeScore = 0;
    name = 0;
    cluster = 10.0;
}

//---------------------------------------------------------------------------//

// Destruktor
//
// Die Teil-Liste und der Nachfolger wird freigegeben

DBMatch_t::~DBMatch_t() {
    delete parts;
    delete next;
}

//---------------------------------------------------------------------------//

// Methode: copy_all
//
// Beschreibung: s. Headerdatei

DBMatch_t *DBMatch_t::copy() throw (DBMatchError) {
    DBMatch_t *ret = new DBMatch_t;
    if (!ret)
	throw DBMatchError("DBMatch_t::copy: Speicherfehler");
    if (name) {
	ret->name = new char[strlen(name) + 1];
	if (!ret->name)
	    throw DBMatchError("DBParts_t::copy: Speicherfehler");
	strcpy(ret->name, name);
    }
    ret->wholeScore = wholeScore;
    ret->wholeLength = wholeLength;
    ret->trend = trend;
    ret->cluster = cluster;
    if (parts)
	ret->parts = parts->copy_all();
    return ret;
}

//---------------------------------------------------------------------------//

// Methode: copy_all
//
// Beschreibung: 

DBMatch_t *DBMatch_t::copy_all() throw (DBMatchError) {
    DBMatch_t *ret = copy();
    if (next)
	ret->next = next->copy_all();
    return ret;
}

// Methode: operator<< 
//
// Beschreibung: s. Headerdatei

ostream& operator<< ( ostream& out, DBMatch_t& match){
  cout << "Matchname: " << match.name << endl << flush;
  cout << "wholeScore = " << match.wholeScore << ", wholeLength= " << match.wholeLength << endl << flush;
  cout <<  "trend = " << match.trend << endl << flush;
  cout << "Teiltreffer: " << endl << "------------------" << endl << flush;
  for (DBParts_t *part=match.parts; part!= NULL; part=part->next) 
    cout << *part << endl << "------------------" << endl << flush;
  return out;
}
