/*****************************************************************************
 ** Dateiname:    DBProperties.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Liest die Konfigurationsdatei aus
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 19.11.2002 | Oliver Schoeffmann      | Erzeugung der Datei
 *****************************************************************************/
#ifndef __dbproperties_hh__
#define __dbproperties_hh__

#include <string>
#include <map>
#include <cfloat>

#include <DBError.hh>
using namespace std;

// Definition von verwendeten Makros
#define PROP_DOUBLE_END DBL_MAX
#define PROP_STRING_END ""


// Definition des Typs zur Speicherung der Konfigurationsdaten
typedef map<string, string> My_map_t;
typedef My_map_t::iterator My_itr_t;

//
// Klasse DBProcessError
//
// Fehlerklasse von DBProcess, abgeleitet von DBError
// Die Art des Fehlers wird durch "m" mitgeteilt

class DBPropertiesError : public DBError {

public:
    DBPropertiesError (const string m) : DBError (m) {}

}; // class DBPropertiesError


// Klasse: DBProperties
//
// Sie bietet Moeglichkeiten die Konfigurationsdatei einzulesen und die 
// einzelnen Werte wiederzugeben.

class DBProperties {
public:

    // Konstruktor

    DBProperties ();

    // Destruktor

    ~DBProperties ();

    // Methode: readFile
    //
    // Beschreibung: Diese Funktion liesst die komplette 
    //               Konfigurationsdatei ein und speichert sie ab.
    //
    // Parameter: 'filename' - Name der Konfigurationsdatei
    //
    // Exception: kein Dateiname, Datei nicht lesbar

    void readFile (const char *filename) throw (DBPropertiesError);

    // Methode: hasProperties
    //
    // Beschreibung: liefert 'true' wenn eine Datei eingelesen wurde

    bool hasProperties ();

    // Methode: clear
    //
    // Beschreibung: Loescht alle bisherigen Daten.

    void clear ();

    // Methode: getInt
    //
    // Beschreibung: Liefert einen Integer-Wert des angegebenen "key"
    //
    // Parameter: 'key' - Name des Parameters
    //
    // Rueckgabewert: Wert des Parameters
    //
    // Exception: Wert ist kein Integer oder "key" existiert nicht.

    int getInt (string key) throw (DBPropertiesError);

    // Methode: getString
    //
    // Beschreibung: Liefert die Zeichenfolge des angegebenen "key"
    //
    // Parameter: 'key' - Name des Parameters
    //
    // Rueckgabewert: 'string'-Objekt mit der Zeichenfolge des Parameters
    //
    // Exception: "key" existiert nicht.

    string getString (string key) throw (DBPropertiesError);

    // Methode: getDouble
    //
    // Beschreibung: Liefert einen Double-Wert des angegebenen "key"
    //
    // Parameter: 'key' - Name des Parameters
    //
    // Rueckgabewert: Wert des Parameters
    //
    // Exception: Wert ist kein Double oder "key" existiert nicht.

    double getDouble (string key) throw (DBPropertiesError);

    // Methode: getStringArray
    //
    // Beschreibung: Liefert ein Feld von Zeichenfolgen zu einen "key"
    //
    // Parameter: 'key' - Name des Parameters
    //
    // Rueckgabewert: Feld von 'string'-Objekten mit den Zeichenfolgen
    //                Der letzte Eintrag ist PORP_STRING_END.
    //
    // Exception: Speicherfehler

    string* getStringArray (string key) throw (DBPropertiesError);

    // Methode: getDoubleArray
    //
    // Beschreibung: Liefert ein Feld von Double-Werten zu einen "key"
    //
    // Parameter: 'key' - Name des Parameters
    //
    // Rueckgabewert: Aufsteigend sortiertes Feld der Double-Werte. 
    //                Der letzte Eintrag ist PROP_DOUBLE_END.
    //
    // Exception: Speicherfehler

    double* getDoubleArray (string key) throw (DBPropertiesError);

private:

    // Private - Methode
    int parseLine (string line, 
		   string &key, 
		   string &value);

    // Private - Variablen
    My_map_t options;
    bool init;
}; // class DBProperties

#endif
