/*****************************************************************************
 ** Dateiname:    DBStore.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Klasse zur Speicherung von Treffern
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 12.12.2002 | Oliver Schoeffmann      | Erzeugung der Datei
 *****************************************************************************/

#ifndef __dbstore_hh__
#define __dbstore_hh__

#include <string>

#include <DBMatch.hh>
#include <DBError.hh>
using namespace std;

//
// Klasse DBStoreError
//
// Fehlerklasse von DBStore, abgeleitet von DBError
// Die Art des Fehlers wird durch "m" mitgeteilt

class DBStoreError : public DBError {

public:
    DBStoreError(const string m) : DBError(m) {}

}; // class DBStoreError


// Klasse: DBStore
//
// Stellt Methoden zum speichern und vergleichen von Komplexen bereit

class DBStore {
public:
    
    // Konstruktor

    DBStore();

    // Destruktor

    ~DBStore();

    // Methode: getMatches
    //
    // Beschreibung: Liefert die im Moment gespeicherten Komplexe.
    //
    // Rueckgabewert: Liste der Komplexe
    //
    // Exception: Kopierfehler

    DBMatch_t *getMatches() throw(DBStoreError);

    // Methode: clear
    //
    // Beschreibung: Loescht alle enthaltenen Komplexe

    void clear();

    // Methode: add
    // 
    // Beschreibung: Fuegt der bestehenden Menge einen Komplex hinzu.
    //
    // Parameter: 'toAdd'   - Komplex, der hinzugefuegt werden soll
    //            'cluster' - true bedeutet, dass der neue Komplex nur mit
    //                             Komplexen verglichen werden soll, die dem
    //                             gleichen "Cluster" angehoeren
    //                        false bedeutet, dass alle Komplexe mit den neuen 
    //                        Komplex verglichen werden.
    //                        Default: false
    //            'single'  - true bedeutet, dass jeder Komplex einzeln 
    //                             gespeichert werden soll.
    //                        false gibt an, dass der neue Komplex mit anderen
    //                        Komplexen verglichen wird (s. cluster)
    //                        Default: false
    //
    // Exception: Kopierfehler
    //

    void add(DBMatch_t *toAdd,
	     bool cluster = false,
	     bool single = false) throw (DBStoreError);

    // Methode: cutWith
    //
    // Beschreibung: Vergleicht einen Komplex mit den enthaltenen Komplexen
    // 
    // Parameter: 'bm'      - der zu vergleichende Komplex
    //            'cluster' - true bedeutet, dass nur Komplexe der selben 
    //                             Clustergruppe verglichen werden
    //                        false bedeutet, alle Komplexe werden verglichen
    //                        Default: false
    //
    // Rueckgabewert: 'true'  - Der Komplex ueberschneidet sich mit einem 
    //                          anderen Komplex.
    //                'false' - Es wurde kein Schnitt gefunden

    bool cutWith(DBMatch_t *bm, bool cluster = true);

    // Methode: getSize
    //
    // Beschreibung: Liefert die Anzahl der Komplexe zurueck, die im Moment
    //               gespeichert werden.

    long getSize();

    // Methode: cleanup
    //
    // Beschreibung: Vergleicht nochmals alle Komplexe miteinander und
    //               entfernt evtl. "doppelte".
    // Bemerkung: Bei der EST-Verarbeitung koennen zwei Komplexe zu einem 
    //            Komplex zusammengelegt werden. Es kann dabei vorkommen, 
    //            dass dabei Komplexe entstehen, die auch zusammengelegt
    //            werden koennen, obwohl es nicht der Fall war, als sie selbst
    //            hinzugefuegt wurden.

    void cleanup();
private:

    // Private - Methoden
    //
    // Beschreibung: s. Headerdatei

    bool singleCut(DBMatch_t *single, 
		   DBMatch_t *other);

    void newSingle(DBMatch_t *insert);

    void newComplex(DBMatch_t *insert) throw (DBStoreError);

    // Private - Variablen
    DBMatch_t *match, *end;
    long size;
}; // class DBStore

#endif
