/*****************************************************************************
 ** Dateiname:    DBAccess.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Bietet den Zugriff auf Sequenzdateien (Header)
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 7.10.2002  | Oliver Schoeffmann      | Erzeugung der Datei
 *****************************************************************************/

#include <string>
#include <fstream>

#include <DBError.hh>
#include <DBGen.hh>
using namespace std;

//
// Klasse DBAccessError
//
// Fehlerklasse von DBAccess, abgeleitet von DBError
// Die Art des Fehlers wird durch "m" mitgeteilt

class DBAccessError : public DBError {

public:
    DBAccessError(string m) : DBError(m) {}

}; // class DBAccessError


//
// Klasse DBAccess
//
// Stellt Methoden fuer den Zugriff auf Sequenzdateien bereit.
// Bearbeitet die Formate "plain" (nur die Sequenz), FASTA und GenBank

class DBAccess {
public:
    // Konstruktor
    //
    // Parameter: Name der Sequenzdatei
    //
    // Exception: "Datei nicht lesbar"

    DBAccess(const char *filename) throw (DBAccessError);

    // Destruktor
    
    ~DBAccess();

    // Methode: nextItem
    //
    // Beschreibung: Liefert die naechste Sequenz aus der Datei. 
    // Diese Klasse bietet die Moeglichkeit mehrere Sequenzen aus einer Datei 
    // nacheinander zu liefern.
    //
    // Vorbedingung: Datei "ifstrm" muss geoeffnet sein.
    //
    // Rueckgabewert: ein Zeiger auf eine DBGen_t Struktur, die die Sequenz
    //                und ggf. noch andere Daten beinhaltet.
    //
    // Exception: "Speicherfehler"

    DBGen_t *nextItem() throw (DBAccessError);

private:

    // Private - Methode: fasta
    //
    // Beschreibung: s. Implementationsdatei

    DBGen_t *fasta(string &name) throw (DBAccessError);


    // Private - Methode: fasta
    //
    // Beschreibung: s. Implementationsdatei

    DBGen_t *genbank() throw (DBAccessError);


    // Private - Variable: ifstrm
    //
    // Sequenzdatei

    ifstream ifstrm;

}; // class DBAccess
