/*****************************************************************************
 ** Dateiname:    DBBlast.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Die Klasse DBBlast stellt die Moeglichkeiten fuer die 
 **               Datenbankanfragen und das parsen der Ausgabe zur Verfuegung
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 2.11.2002  | Oliver Schoeffmann      | Erzeugung der Datei
 *****************************************************************************/

#ifndef __dbblast_hh__
#define __dbblast_hh__

#include <string>
#include <fstream>

#include <DBError.hh>
#include <DBProperties.hh>
#include <DBMatch.hh>

using namespace std;

// enum: DB_t
//
// Legt die Art der Datenbakabfrage fest.

typedef enum { EST = 0, PROT } DB_t;


//
// Klasse DBBlastError
//
// Fehlerklasse von DBBlast, abgeleitet von DBError
// Die Art des Fehlers wird durch "m" mitgeteilt

class DBBlastError : public DBError {

public:
    DBBlastError(const string m) : DBError(m) {}

}; // class DBBlastError


//
// Klasse DBBlast
//
// Stellt Methoden zur Verfuegung, um die Datenbankabfrage durchzufuehren und 
// die Ausgabedatei zu verarbeiten.

class DBBlast {
public:
    
    // Konstruktor
    //
    // Parameter: Ein Objekt vom Typ 'DBProperties'

    DBBlast(DBProperties p);

    // Destruktor

    ~DBBlast();

    
    // Methoden: process
    //
    // Beschreibung: Fuehren eine Datenbankabfrage durch und veranlassen 
    //               eine Bearbeitung der Suchergebnisse.
    //
    // Unterschied: In der einen Version kann durch Angabe eines Dateinamens
    //              festgelegt werden, in welche Datei die Suchergebnisse 
    //              geschrieben werden sollen. Diese Datei bleibt erhalten.
    //
    // Parameter: 'sequence'   - die zu untersuchende Sequenz
    //            <'keepfile'> - Datei in der die Suchergebnisse der Datenbank
    //                           erhalten bleiben sollen
    //            'db'         - Art der Datenbakabfrage (EST oder PROT) 
    //                           Default: PROT
    //
    // Exception: Fehler, wenn die Sequenz nicht in eine Datei geschrieben 
    //            werden kann (fuer die Datenbankanfrage)
    //
    // Rueckgabewert: Zeiger auf den Beginn einer einfach verketteten Liste aus
    //                'DBMatch_t' Strukturen.
    //                0, falls keine Suchergebnisse vorhanden sind.

    DBMatch_t *process(const char *sequence, 
		       DB_t db = PROT) throw(DBBlastError);
    DBMatch_t *process(const char *sequence, 
		       const char *keepfile, 
		       DB_t db = PROT) throw(DBBlastError);


    // Methode: parseFile
    //
    // Beschreibung: Verarbeitet die Suchergebnisse
    //
    // Parameter: 'filename': Name der zu bearbeitenden Datei
    //
    // Rueckgabewert: Zeiger auf den Beginn einer einfach verketteten Liste aus
    //                'DBMatch_t' Strukturen.
    //                0, falls keine Suchergebnisse vorhanden sind.
    //
    // Exception: Speicherfehler, Datei nicht lesbar, kein Dateinname und 
    //            falscher Aufbau der Datei.

    DBMatch_t *parseFile(const char *filename) throw(DBBlastError);
private:

    // Private - Methode: insert
    //
    // Beschreibung: s. Implementationsdatei

    void insert(DBMatch_t *m,
		DBParts_t *p);

private:

    // Private - Variablen

    ifstream ifstrm;
    DBProperties prop;
    char *seq;
    bool file;

}; // class DBBlast

#endif
