/*****************************************************************************
 ** Dateiname:    DBCombined.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Kombinierte EST- und Proteinverarbeitung
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 2.4.2003   | Oliver Schoeffmann      | Erzeugung der Datei
 *****************************************************************************/

#ifndef __dbcombined_hh__
#define __dbcombined_hh__

#include <string>

#include <DBError.hh>
#include <DBProperties.hh>

using namespace std;

//
// Klasse DBCombinedError
//
// Fehlerklasse von DBCombined, abgeleitet von DBError
// Die Art des Fehlers wird durch "m" mitgeteilt

class DBCombinedError : public DBError {

public:
    DBCombinedError(const string &m) : DBError(m) {}

}; // class DBCombinedError


// Klasse DBCombined
//
// Stellt Methoden fuer eine kombinierte EST- und Proteinverarbeitung zur
// Verfuegung

class DBCombined {
public:

    // Konstruktor
    //
    // Parameter: Ein Objekt vom Typ 'DBProperties'

    DBCombined(DBProperties properties);

    // Konstruktor
    //
    // Defaultkostruktor

    DBCombined();

    // Destruktor

    ~DBCombined();


    // Methode: setProperties
    //
    // Beschreibung: Weist der Klasse ein (neues) DBProperties Objekt zu
    //
    // Parameter: Ein Objekt vom Typ 'DBProperties'
    
    void setProperties(DBProperties properties);


    // Methode: combinedProcess
    //
    // Beschreibung: Fuehrt die kombinierte EST- und Proteinverarbeitung durch
    //
    // Parameter: 'sequence'    - Die zu untersuchende Sequenz
    //            'est_matches' - Eine Liste der Treffer aus der 
    //                            EST-Verarbeitung
    //
    // Rueckgabewert: Eine Liste der Ergebnisse der kombinierte Verarbeitung
    //
    // Exception: Speicherfehler, Fehler bei der Datenbankanfrage,
    //            Fehler innerhalb der EST-Treffer

    DBMatch_t *combinedProcess(const char *sequence,
			       DBMatch_t *est_matches) throw (DBCombinedError);


private:

    // Private - Methoden
    //
    // Beschreibung: s. Implementationsdatei

    DBMatch_t *setOffset(DBMatch_t *m) throw (DBCombinedError);

    char *getMatchSequence(DBMatch_t *m) throw (DBCombinedError);

    DBMatch_t *transform(DBMatch_t *bm, 
			 DBMatch_t *dbm) throw (DBCombinedError);

    bool isStart(long start, 
		 bool reverse = false);

    bool isEnd(long end, 
	       bool reverse = false);

    void setFrames(DBMatch_t *m);

    void readProps(void);

    bool namecheck(const char *name);

private:

    // Private - Variablen

    const char *seq;
    string *s_ignore, *s_has;
    long threshold;
    double ratio;
    DBProperties props;

}; // class DBCombined

#endif
