/*****************************************************************************
 ** Dateiname:    DBError.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Basisfehlerklasse
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 29.9.2002  | Oliver Schoeffmann      | Erzeugung der Datei
 *****************************************************************************/

#ifndef __db_error__
#define __db_error__

#include <string>
using namespace std;


//
// Klasse DBError
//
// Basisfehlerklasse des Projekts

class DBError {
private:

    // Private - Variable: message
    //
    // Dient zur Angabe des aufgetretenen Fehlers

    string message;

public:

    // Konstruktor
    //
    // Parameter: 'm' - Fehlerbeschreibung

    DBError(const string &m) : message(m) {}

    // Destruktor

    ~DBError() {}

    // Methode: getMessage
    //
    // Beschreibung: Liefert die Fehlermeldung

    const string& getMessage() const { return message; }

}; // class DBError

#endif
