/*****************************************************************************
 ** Dateiname:    DBEst.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Est-Verarbeitung
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 7.11.2002  | Oliver Schoeffmann      | Erzeugung der Datei
 *****************************************************************************/

#ifndef __dbest_hh__
#define __dbest_hh__

#include <string>

#include <DBError.hh>
#include <DBMatch.hh>
#include <DBProperties.hh>

using namespace std;

//
// Klasse DBEstError
//
// Fehlerklasse von DBEst, abgeleitet von DBError
// Die Art des Fehlers wird durch "m" mitgeteilt

class DBEstError : public DBError {

public:
    DBEstError(const string m) : DBError(m) {}

}; // class DBEstError


// Klasse DBEst
//
// Stellt Methoden fuer die EST-Verarbeitung bereit

class DBEst {
public:

    // Konstruktor
    //
    // Parameter: ein Objekt vom Typ 'DBProperties'

    DBEst(DBProperties properties);

    // Konstruktor

    DBEst();

    // Destruktor

    ~DBEst();
    

    // Methode: proceed
    //
    // Beschreibung: Fuert die EST-Verarbeitung durch
    //
    // Parameter: 'sequence' - Die zu untersuchende Sequenz
    //            'estfile'  - Eine Datei, in der schon die Suchergebnisse
    //                         einer EST-Suche enthalten sind.
    //                         Default: 0 (EST-Suche selbst durchfuehren)
    //            'single'   - true: EST-Treffer werden einzeln betrachtet
    //                         false: EST-Treffer werden gemischt
    //                         Default: false.
    //            'cluster'  - true: EST-Treffer werden in verschiedene Gruppen
    //                               (nach e-Wert) einsortiert.
    //                         false: alle EST-Treffer werden gemeinsam 
    //                                betrachtet
    //                         Default: false.
    //
    // Rueckgabewert: Eine Liste der Ergebnisse der EST-Verarbeitung
    // 
    // Exception: Speicherfehler, Fehler von "ausserhalb"

    DBMatch_t *proceed(const char *sequence,
		       const char *estfile = 0,
		       const bool single = false,
		       const bool cluster = false) throw (DBEstError);


    // Methode: setProperties
    //
    // Beschreibung: Weist der Klasse ein (neues) DBProperties Objekt zu
    //
    // Parameter: Ein Objekt vom Typ 'DBProperties'

    void setProperties(DBProperties properties);

private:

    // Private - Methoden
    //
    // Beschreibung: s. Implementationsdatei.

    DBMatch_t *cleanup(DBMatch_t *bm) throw (DBEstError);

    void clustern(DBMatch_t *m);

    int checkForIntron(long to, 
		       long from);

    int hasIntron(DBParts_t *p, 
		  DBParts_t *q, 
		  int pre_trend);

    void readProps();

    bool namecheck(const char *name);

private:

    // Private - Variablen
    const char *seq;
    long threshold;
    double ratio, *cluster_buckets;
    int cutoff;
    string *s_ignore, *s_has;
    DBProperties props;
};

#endif
