/*****************************************************************************
 ** Dateiname:    DBGen.hh
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Struktur, die beim Einlesen der Eingabesequenz erzeugt wird
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 7.10.2002  | Oliver Schoeffmann      | Erzeugung der Datei
 ** 12.4.2003  | Oliver Schoeffmann      | Anpassung der Strukturen um
 **                                      | mehrere CDS zuzulassen
 *****************************************************************************/

#ifndef __dbgen_hh__
#define __dbgen_hh__

#include <string>
using namespace std;

// Bemerkung:
// Die Strukturen DBGenParts_t und DBGenCDS_t werden vor allem fuer
// Testlaufe benoetigt.


// Struktur: DBGenParts_t
//
// Laesst sich als ein "Exon" in der Annotation interpretieren.
// Wird nur aus einer Sequenzdatei im GenBank-Format erstellt, wenn dort eine
// Annotation angegeben ist.

struct DBGenParts_t {
    long from, to;
    bool exon, full, intron, ass, dss;
    DBGenParts_t *next;
    DBGenParts_t() { 
	next = 0; 
	exon = full = intron = ass = dss = false;
    };
    ~DBGenParts_t() { delete next; };
};


// Struktur: DBGenCDS_t
//
// Beinhaltet eine komplette Annotation aus einer GenBank-Datei (s.o.)

struct DBGenCDS_t {
    int trend;
    DBGenCDS_t *next;
    DBGenParts_t *parts;
    DBGenCDS_t() { next = 0; parts = 0; };
    ~DBGenCDS_t() { delete parts; delete next; };
};


// Struktur: DBGen_t
//
// In dieser Struktur kann die reine Sequenz, der Bezeichner der Sequenz und
// die Laenge gespeichert werden.
// Fuer eine GenBank-Datei ist noch die Moeglichkeit fuer die Annotation 
// gegeben.

struct DBGen_t {
    string name, sequence;
    long length;
    DBGenCDS_t *cds;
    DBGen_t() { cds = 0; };
    ~DBGen_t() { delete cds; };
};

#endif
