/*****************************************************************************
 ** Dateiname:    DBProcess.cc
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Steuerung der verschieden Abfragemoeglichkeiten
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 9.12.2002  | Oliver Schoeffmann      | Erzeugung der Datei (nur mit EST)
 ** 19.2.2003  | Oliver Schoeffmann      | Hinzufuegen der Proteinverarbeitung
 ** 2.4.2003   | Oliver Schoeffmann      | Hinzufuegen der kombinierten Abfrage
 *****************************************************************************/

#include <DBEst.hh>
#include <DBProt.hh>
#include <DBProcess.hh>
#include <DBCombined.hh>
using namespace std;

// Konstruktor

DBProcess::DBProcess() {
}

//---------------------------------------------------------------------------//

// Konstruktor

DBProcess::DBProcess(DBProperties properties) {
    props = properties;
}

//---------------------------------------------------------------------------//

//Konstruktor

DBProcess::~DBProcess() {
}

//---------------------------------------------------------------------------//

// Methode: setProperties
//
// Beschreibung: s. Headerdatei
void DBProcess::setProperties(DBProperties properties) {
    props = properties;
}

//---------------------------------------------------------------------------//

// Methode process
// 
// Beschreibung: s. Headerdatei

DBMatch_t *DBProcess::process(const char *sequence,
			      const char *estfile) throw (DBProcessError) {
    if (!sequence)
        throw DBProcessError("DBProcess::process: keine Sequenz angegeben");
    DBMatch_t *prot_est;
    try {
	DBEst est(props);
	DBCombined comb(props);
	DBMatch_t *est_matches;
	est_matches = est.proceed(sequence, estfile);
	/* Ausgabe der EST-Matches
	   for (DBMatch_t *match = est_matches; match != NULL ; match = match->next)
	   cout << *match << endl; 
	*/

	prot_est = comb.combinedProcess(sequence, est_matches);
    } catch (DBError &err) {
	throw DBProcessError((string)"DBProcess::process: "
			     "Fehler produziert durch:\n" +
			     err.getMessage());
    }
    return prot_est;
} // process

//---------------------------------------------------------------------------//

// Methode: processEST
// 
// Beschreibung: s. Headerdatei

DBMatch_t *DBProcess::processEST(const char *sequence,
				 const char *filename,
				 bool single,
				 bool cluster) throw (DBProcessError) {
    if (!sequence)
        throw DBProcessError("DBProcess::processEST: keine Sequenz angegeben");
    DBEst est(props);
    DBMatch_t *est_matches;
    try {
	est_matches = est.proceed(sequence, filename, 
				  single, cluster);
    } catch (DBEstError &err) {
	throw DBProcessError((string)"DBProcess::processEST: "
			     "Fehler produziert durch:\n" + err.getMessage());
    }
    return est_matches;
} // processEST

//---------------------------------------------------------------------------//

// Methode: processPROT
// 
// Beschreibung: s. Headerdatei

DBMatch_t *DBProcess::processPROT(const char *sequence,
				  const char *filename,
				  bool cluster) throw (DBProcessError) {
    if (!sequence)
        throw DBProcessError("DBProcess::processPROT: "
			     "keine Sequenz angegeben");
    DBProt prot(props);
    DBMatch_t *prot_matches = 0;
    try {
	prot_matches = prot.pureProcess(sequence, filename,
					cluster);
    } catch (DBProtError &err) {
	throw DBProcessError((string)"DBProcess::processPROT: "
			     "Fehler produziert durch:\n" + err.getMessage());
    }
    return prot_matches;
} // processPROT
