/*****************************************************************************
 ** Dateiname:    DBProperties.cc
 ** Projekt:      Gewinnung extrinsischer Informationen durch Datenbankabfragen
 ** Beschreibung: Liest die Konfigurationsdatei aus
 ** Autor:        Oliver Schoeffmann
 **
 ** Copyright:    @Schoeffmann
 **
 ** Datum      | Autor                   | Beschreibung
 ** --------------------------------------------------------------------------
 ** 19.11.2002 | Oliver Schoeffmann      | Erzeugung der Datei
 *****************************************************************************/

#include <fstream>
#include <strstream>
#include <cstdlib>
#include <iomanip>

#include <DBProperties.hh>

using namespace std;

static string separator("--::--");


///////////////////////////////////////////////////////////////////////////////
// Public - Methoden
///////////////////////////////////////////////////////////////////////////////

// Konstruktor

DBProperties::DBProperties () { 
    init = false; 
}

//---------------------------------------------------------------------------//

// Destruktor

DBProperties::~DBProperties () {
}

//---------------------------------------------------------------------------//

// Methode: readFile
//
// Beschreibung: s. Headerdatei

void DBProperties::readFile(const char *filename) throw(DBPropertiesError){
    clear();
    if (!filename)
	throw DBPropertiesError("DBProperties: Kein Dateiname angegeben");
    ifstream ifstrm(filename);
    if (ifstrm.fail())
	throw DBPropertiesError((string)"DBProperties: " + filename +
				" nicht lesbar");
    string key, value, line;
    int values;
    while (!ifstrm.eof()) {
	getline (ifstrm, line);
	if((values = parseLine(line, key, value))) {

	    // Bestimmte Schluessel koennen mehrere Eintraege haben
	    if (values != 1) {
		if (key == "blast_options" || key == "wublast_options" || key=="wublastn_options" || key=="wublastx_options") {
		    while (strstr(value.c_str(), separator.c_str()))
			value.replace(value.find(separator), 
				      separator.length(), " "); 
		} else if (strstr(key.c_str(), "ignore") == NULL &&
			   strstr(key.c_str(), "has") == NULL    &&
			   strstr(key.c_str(), "cluster") == NULL)
		    value.erase(value.find(separator));
	    }
	    options.insert(pair<string, string>(key, value));
	}
    }
    ifstrm.close();
    init = true;
} // readFile

//---------------------------------------------------------------------------//

// Methode: hasProperties
//
// Beschreibung: s. Headerdatei

bool DBProperties::hasProperties() {
    return init;
} // hasProperties

//---------------------------------------------------------------------------//

// Methode: clear
//
// Beschreibung: s. Headerdatei

void DBProperties::clear() {
    options.clear();
    init = false;
} // clear

//---------------------------------------------------------------------------//

// Methode: getInt
//
// Beschreibung: s. Headerdatei

int DBProperties::getInt(string key) throw(DBPropertiesError) {
    istrstream strstr(getString(key).c_str());
    int i;
    if (strstr >> i)
	return i;
    throw DBPropertiesError("DBProperties::getInt: Wert von " + key +
			    " ist kein gueltiger Integerwert.");
} // getInt

//---------------------------------------------------------------------------//

// Methode: getString
//
// Beschreibung: s. Headerdatei

string DBProperties::getString(string key) throw(DBPropertiesError) {
    My_itr_t pos = options.find(key);
    if (pos == options.end())
	throw DBPropertiesError("DBProperties::getString: " + key +
				" Existiert nicht.");
    return pos->second;
} // getString

//---------------------------------------------------------------------------//

// Methode: getDouble
//
// Beschreibung: s. Headerdatei

double DBProperties::getDouble(string key) throw(DBPropertiesError) {
    istrstream strstr(getString(key).c_str());
    double g;
    if (strstr >> g)
	return g;
    throw DBPropertiesError("DBProperties::getDouble:Wert von " + key +
			    " ist kein gueltiger Doublewert.");    
} // getDouble

//---------------------------------------------------------------------------//

// Methode: getStringArray
//
// Beschreibung: s. Headerdatei

string *DBProperties::getStringArray(string key) throw(DBPropertiesError) {
    My_itr_t pos = options.find(key);
    if (pos == options.end())
	return 0;
    int count;
    string *ret = 0, value = pos->second;
    for (count = 2; strstr(value.c_str(), separator.c_str()) != NULL; count++)
	value.erase(0,value.find(separator) + separator.length());
    ret = new string[count];
    if (!ret)
	throw DBPropertiesError("DBProperties::getAllStrings: "
				"Speicherfehler");
    value = pos->second;
    for (int i = 0; i < count - 2; i++) {
	ret[i] = value.substr(0, value.find(separator));
	value.erase(0,value.find(separator) + separator.length());
    }
    ret[count - 2] = value;
    ret[count - 1].assign(PROP_STRING_END);
    return ret;
} // getStringArray

//---------------------------------------------------------------------------//

// Methode: getDoubleArray
//
// Beschreibung: s. Headerdatei

double *DBProperties::getDoubleArray(string key) throw(DBPropertiesError) {
    My_itr_t pos = options.find(key);
    if (pos == options.end())
	return 0;
    int count;
    string word, value = pos->second;
    double *ret = 0;
    for (count = 2; strstr(value.c_str(), separator.c_str()) != NULL; count++)
	value.erase(0,value.find(separator) + separator.length());
    ret = new double[count];
    if (!ret)
	throw DBPropertiesError("DBProperties::getAllStrings: "
				"Speicherfehler");
    value = pos->second;
    for (int i = 0; i < count - 2; i++) {
	word = value.substr(0, value.find(separator));
	if (isalpha(word[0]))
	    word = '1' + word;
	ret[i] = atof(word.c_str());
	value.erase(0,value.find(separator) + separator.length());
    }
    if (isalpha(value[0]))
	value = '1' + value;
    ret[count - 2] = atof(value.c_str());
    ret[count - 1] = PROP_DOUBLE_END;

    // array sortieren
    for (int i = 0; i < count - 1; i++)
	for (int j = count - 1; j > i; j--)
	    if (ret[j] < ret[j - 1]) {
		double tmp = ret[j];
		ret[j] = ret[j - 1];
		ret[j - 1] = tmp;
	    }

    return ret;
} // getDoubleArray


///////////////////////////////////////////////////////////////////////////////
// Private - Methode
///////////////////////////////////////////////////////////////////////////////

// Methode: readFile
//
// Beschreibung: Untersucht eine Zeile auf Parameter und deren Werte
//               Alles vor einem '#' wird beachtet. Das erste Wort ist der 
//               "key", alle anderen Worte sind die Werte des "key".
//
// Parameter: 'line'  - Die zu untersuchende Zeile
//            'key'   - Referenz in der der Schluessel gespeichert wird
//            'value' - Referenz in der die Werte durch 'separator' getrennt
//                      gespeichert werden.
//
// Rueckgabewrt: Anzahl der gelesenen Werte

int DBProperties::parseLine(string line, 
			    string &key, 
			    string &value) {
    int ret;
    if (strchr(line.c_str(), '#') != NULL)
	line.erase(line.find('#'));
    istrstream istrm(line.c_str());
    string word;
    if (!(istrm >> key))
	return 0;
    if (!(istrm >> value))
	return 0;
    ret = 1;
    while (istrm >> word) {
	value += separator + word;
	ret++;
    }
    return ret;
} // parseLine

