/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class RowNumberTable
extends JTable
implements ChangeListener,
PropertyChangeListener {
    private JTable main;

    public RowNumberTable(JTable jTable) {
        this.main = jTable;
        this.main.addPropertyChangeListener(this);
        this.setFocusable(false);
        this.setAutoCreateColumnsFromModel(false);
        this.setModel(this.main.getModel());
        this.setSelectionModel(this.main.getSelectionModel());
        TableColumn tableColumn = new TableColumn();
        tableColumn.setHeaderValue(" ");
        this.addColumn(tableColumn);
        tableColumn.setCellRenderer(new RowNumberRenderer());
        this.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        this.setAutoResizeMode(jTable.getAutoResizeMode());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            jViewport.addChangeListener(this);
        }
    }

    @Override
    public int getRowCount() {
        return this.main.getRowCount();
    }

    @Override
    public int getRowHeight(int n) {
        return this.main.getRowHeight(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return Integer.toString(n + 1);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JViewport jViewport = (JViewport)changeEvent.getSource();
        JScrollPane jScrollPane = (JScrollPane)jViewport.getParent();
        jScrollPane.getVerticalScrollBar().setValue(jViewport.getViewPosition().y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
            this.setSelectionModel(this.main.getSelectionModel());
        }
        if ("model".equals(propertyChangeEvent.getPropertyName())) {
            this.setModel(this.main.getModel());
        }
    }

    private static class RowNumberRenderer
    extends DefaultTableCellRenderer {
        public RowNumberRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            if (bl) {
                this.setFont(this.getFont().deriveFont(1));
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }
}

