#ifndef GRAPH_TYPES_H_
#define GRAPH_TYPES_H_

#ifndef _STDDEF_H
#include <stddef.h>
#endif // _STDDEF_H

#ifndef _STDINT_H
#include <stdint.h>
#endif // _STDINT_H

namespace	GraphGen	{

template<typename T>
struct Node		{

	int64_t		m_Id;
	T			m_Nd;

	Node		():m_Id(-1), m_Nd()
	{  }

	Node		(T n, int64_t id=0):m_Id(id), m_Nd(n)
	{  }

	Node		(const Node& n) {
		*this = n;
	}

	~Node		()	{  }

	Node<T>&
	operator=	(const Node& n)		{
		if(this != &n) {
			m_Nd = n.m_Nd;
			m_Id = n.m_Id;
		}
		return *this;
	}
};

template<typename T>
struct Edge		{

	T	m_Node_1;
	T	m_Node_2;

	Edge		():m_Node_1(), m_Node_2()
	{ }

	Edge		(T n1, T n2):m_Node_1(n1), m_Node_2(n2)
	{ }

	Edge		(const Edge<T>& e) {
		m_Node_1 = e.m_Node_1;
		m_Node_2 = e.m_Node_2;
	}

	~Edge		() {   }

	Edge<T>&
	operator=		(const Edge<T>& e) {
		if(&e != this) {
			m_Node_1 = e.m_Node_1;
			m_Node_2 = e.m_Node_2;
		}
		return *this;
	}
};

//struct	Graph;

} // GraphGen

#endif // GRAPH_TYPES_H_


