#include "mrf_utils.h"
#include <sys/types.h>
#include <log/log.h>

bool
s_Verbose	=	false;

void
usage() {
    printf ("\nAufruf: program [OPTIONS] {COMMANDS}\n"
            " Testumgebung der MRF Tools.\n\n"
            " COMMANDS sind:\n"
    		"	swap	-- MAP Schaetzung mittels alpha-beta-Swap-Algorithmus\n\n"
    		"	load-field	-- binaeres MRF 1. Ordnung laden\n\n"
            "\n OPTIONS sind:\n"
            "	-v	-- wortreicher Modus\n"
            "\n"
            );
    exit(1);
}

int main(int argc, char** argv) {
    int32_t t(0);
    u_int32_t   add_this(0);
    std::string nm;
    bool load_field(false), swap_map(false);
    for(t=0; t < argc; t+=add_this) {
        if (strcmp(argv[t],"-v") == 0) {
            s_Verbose = true;
            add_this = 1;
        } else if(strcmp(argv[t],"-help") == 0)
            usage();
    	else if(strcmp(argv[t],"swap") == 0)
    		swap_map = true, add_this = 1;
        else if (t+1 < argc && strcmp(argv[t],"load-field") == 0) {
            nm.assign(argv[t+1],strlen(argv[t+1]));
            add_this = 2;
            load_field = true;
        }
        else if(t == 0)
            t++;
        else
            usage();
    }

    Log::get()->init_logs();

    if(load_field) {
    	GraphGen::MRFscope::Utils::Init();
    	if(GraphGen::MRFscope::Utils::Read_MRFspec(nm.c_str()) && swap_map) {
    		GraphGen::MRFscope::Utils::Compute_MAP();
    	}
    	GraphGen::MRFscope::Utils::Clean_MRFspec();
    }
    Log::get()->end_logs();

	return 0;
}
