/*
 * mrf_utils.h
 *
 *  Created on: 22 Nov 2010
 *      Author: torsten
 */

#ifndef MRF_UTILS_H_
#define MRF_UTILS_H_

#ifndef GRAPH_GEN_H_INCLUDED
#include <graph_gen.h>
#endif // GRAPH_GEN_H_INCLUDED

#ifndef	_SYS_TYPES_H
#include <sys/types.h>
#endif // _SYS_TYPES_H

#ifndef __MRF_H__
#include <MRF2.1/mrf.h>
#endif // __MRF_H__

namespace 	GraphGen			{

namespace	MRFscope		{

	struct	Q_DataTerm	{
		float	m_Q	[2];
	};

	struct Edge_Ising : public Edge<Node<Q_DataTerm>* > {

		static
		const float
				ISING_MODEL_CONST;

		static
		float	m_G					[4];
		void	Apply_IsingModel	();
	};

	class	Utils	{

		enum MRF_ReadState	{
			MRF_Readstate_idle	=	0,
			MRF_Readstate_nodes	=	1,
			MRF_Readstate_edges	=	2
		};

	private:
		static
		MRF_ReadState 	m_State;

		static
		Node<Q_DataTerm>*
						m_Nodes;

		static
		Edge_Ising* 	m_Edges;

		static
		bool			m_Loaded,
						m_Init_Called;

		/* Configuration Graph and Labels	*/
		static
		u_int32_t 		m_No_Nds,
						m_No_Edges,
						m_No_Labels;

		static
		const float
						COST_SCALAR;

	public:
		/**	Read in an label graph spec
		 * \param	filename	- file
		 * \return	TRUE		- successful loades, FALSE otherw.
		 */
		static
		bool			Read_MRFspec	(const char* filename);

		/** Makes an Gibbsian Field Spec. from current values
		 *	for Kolmogorov/Zabih interface structures
		 */
		static
		EnergyFunction*	Generate_MRF2_1_fromSpec
										();
		static
		MRF::CostVal	DateCost_MRFspec
										(int node, MRF::Label label);

		static
		MRF::CostVal 	SmoothCostGeneralFn
										(int n1, int n2,  MRF::Label l1, MRF::Label l2);

		static
		void			Compute_MAP		();


		static
		void			Init			();

		static
		void			Clean_MRFspec	();
	};

} } // GraphGen::MRFscope;

#endif /* MRF_UTILS_H_ */
