#include "train_utils.h"
#include "train_types.h"
#include <log/log.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef	CLUSTER_BUILD
static	char	boot_info	[] =	"owner:\twierschin@cm(192.168.34.1 )\nrunning:\tLinux cm 2.6.16.60-0.42.10-smp #1 SMP Tue Apr 27 05:11:27 UTC 2010 x86_64 x86_64 x86_64 GNU/Linux\nbuilt:\t2013-06-03 -- 16:46:43\n";
#endif // CLUSTER_BUILD

void
usage(const char* p) {
    printf ("\033[31mError: %s\033[0m"
    		"\nProgram call: program [OPTIONS] {COMMANDS}\n"
            " testframe for CRF tools.\n\n"

            " COMMANDS sind:\n"
    		"	learn                  -- Estimate parameters.\n"
    		"	validation             -- Validate parameters against test set.\n"
    		"	prediction             -- Classify against third unknow test set.\n"
    		"	parse                  -- Build up structures, do nothing but just reading in files.\n"
    		"	output-graphs          -- Print model graphs to files as input for Goettingen's algorithm.\n\n"

            "\n OPTIONS sind:\n\n"
    		"	-learn-dir        DIR  -- Sets directory to load from training examples.\n\n"

    		"	-learn-optfunc    FUNC [fpr tpr]\n"
    		"	                       -- Optimization functional for learning:\n"
    		"	                          FUNC is {roc-curve, roc-set-1, roc-set-2, roc-diff}, default:roc-curve.\n"
    		"	                          For roc-set-i optional args can be applied, default fpr=.3,tpr=.4.\n\n"

    		"	-f[p,n]-scale	  SCALE\n"
    		"	                       -- Scalars for FP,FN within loss function used for OLM, default both 1.\n"
    		"	                          assertion applied: one must be 1.\n\n"

    		"	-learn-chunksize  NR   -- Sets number of training examples after averaging parameters shall been done.\n\n"

    		"	-[no]learn-edge-model  -- Controls handling of edge model while learning.\n"
    		"	                          default: learn the edge model\n\n"

    		"	-validation-dir   DIR  -- Verzeichnis zur Bewertung der aktuellen Parameter.\n\n"

    		"	-prediction-dir   DIR  -- Verzeichnis der tatsaechlich zu klassifizierenden Daten.\n\n"

    		"	-rgdata-dir       DIR  -- Verzeichnis der rg-Files.\n\n"

    		"	-fedata-dir       DIR  -- Verzeichnis der fe-Files.\n\n"

    		"	-kylabels-dir     DIR  -- Verzeichnis der Keyu Labellings der rg Proteine.\n\n"

    		"	-output-dir       DIR  -- Verzeichnis zum Sichern von Ergebnissen.\n\n"

    		"	-stats-per-object      -- Prints statistics for each input protein.\n\n"

    		"	-log-dir          DIR  -- Logging Verzeichnis angeben(default: working directory).\n\n"

    		"	-no-logdomain          -- Runs prediction algorithms not in log-domain.\n\n"

    		"	-no-conserv            -- Feature Conservation-extended shall not be used within any processing.\n\n"

    		"	-no-rasa               -- Feature RASA-extended shall not be used within any processing.\n\n"

    		"	-no-pssm               -- Feature PSSM-extended shall not be used within any processing.\n\n"

    		"	-no-epros              -- Feature EPROS shall not be used within any processing.\n\n"

    		"	-no-rg                 -- Feature RG shall not be used within any processing.\n\n"

    		"	-no-fe                 -- Feature FE shall not be used within any processing.\n\n"

    		"	-config-rg-data   RG   -- configuration of rg data, RG in {data,keyu}; default: data.\n\n"

    		"	-intermediates    NR   -- Shows more intermediate results.\n\n"

    		"	-steps-per-sample NR   -- maximum number of learn steps per training example; (default: 30).\n\n"

    		"	-learnrounds-oninput NR-- number of rounds on each training example.\n\n"

    		"	-input-proteins   FILE -- takes FILE as input protein complexes.\n\n"

    		"	-edge-model       ALPHA BETA\n"
    		"	                       -- user supplied edge model (default: .5 .5)\n\n"

    		"	-[no]energy-terms      -- Controls whether exponential of potentials is to be taken (default: no).\n\n"

    		"	-[no]set-weight-tozero-if-negative\n"

    		"	                       -- Controls whether weights are to set to zero if they have been decreased\n"
    		"	                          to negative values while learning (default: yes).\n\n"

    		"	-[no]bin-features      -- Estimates weights for each bin of a feature (default: no).\n\n"

    		"	-infer-with-gibbs      -- Estimates aposteriori prob. by Gibbs sampling only (default chain: BP -> Gibbs).\n\n"

    		"	-atom-dist-edge-include AONGSTROM\n"
    		"	                       -- atomic distance threshold within chain causing an edge inclusion\n"
    		"	                          into model graph, default 7.0 Ao\n\n"

    		"	-help                  -- This help shows up\n\n"
            "	-v                     -- verbose mode\n\n"
            "	-V                     -- more verbose mode\n\n"
            "\n",p
            );
    exit(1);
}

int main(int argc, char** argv) {

	Training::Types::Cmd cmd(Training::Types::Cmd_Idle);
    int32_t t(0);
    size_t no(0);
    u_int32_t   add_this(0);
    double d(0.0), alpha(0.0), beta(0.0);
    char* logdir(NULL);
    bool more_verbose(false);

#ifdef	CLUSTER_BUILD
    printf("%s",boot_info);
#endif  // CLUSTER_BUILD

    for(t=1; t < argc; t+=add_this) {
        if (strcmp(argv[t],"-v") == 0)
        	Training::Utils::SetVerbose(true), add_this = 1;
        else if (strcmp(argv[t],"-V") == 0) {
        	more_verbose = true;
        	Training::Utils::SetVerbose(more_verbose);
        	Training::Utils::SetMoreVerbose(more_verbose);
        	add_this = 1;
        } else if(strcmp(argv[t],"-help") == 0)
            usage(argv[t]);
		else if(strcmp(argv[t],"learn") == 0)
			cmd = Training::Types::Cmd_Learn, add_this = 1;
		else if(strcmp(argv[t],"parse") == 0)
			cmd = Training::Types::Cmd_Parse, add_this = 1;
		else if(strcmp(argv[t],"validation") == 0)
			cmd = Training::Types::Cmd_Validate, add_this = 1;
		else if(strcmp(argv[t],"prediction") == 0)
			cmd = Training::Types::Cmd_Classify, add_this = 1;
		else if(strcmp(argv[t],"output-graphs") == 0)
			cmd = Training::Types::Cmd_ModelGraphs, add_this = 1;
    	else if(strcmp(argv[t],"-learn-dir") == 0 && t+1<argc)
    		Training::Utils::Set_FeaturesDIR(argv[t+1]), add_this = 2;
    	else if(strcmp(argv[t],"-validation-dir") == 0 && t+1<argc)
    		Training::Utils::Set_ValidationDIR(argv[t+1]), add_this = 2;
    	else if(strcmp(argv[t],"-rgdata-dir") == 0 && t+1<argc)
    		Training::Utils::Set_RgData_Dir(argv[t+1]), add_this = 2;
    	else if(strcmp(argv[t],"-fedata-dir") == 0 && t+1<argc)
    		Training::Utils::Set_FeData_Dir(argv[t+1]), add_this = 2;
    	else if(strcmp(argv[t],"-kylabels-dir") == 0 && t+1<argc)
    		Training::Utils::Set_KyLabels_Dir(argv[t+1]), add_this = 2;
    	else if(strcmp(argv[t],"-input-proteins") == 0 && t+1<argc)
    		Training::Utils::SetInputFile_Proteins(argv[t+1]), add_this = 2;
    	else if(strcmp(argv[t],"-prediction-dir") == 0 && t+1<argc)
    		Training::Utils::Set_PredictionDIR(argv[t+1]), add_this = 2;
    	else if(strcmp(argv[t],"-atom-dist-edge-include") == 0 && t+1<argc) {
    		d = strtod(argv[t+1],NULL);
    		Training::Utils::SetDynmEdge_Distance(d), add_this = 2;
    	} else if(strcmp(argv[t],"-stats-per-object") == 0)
    		Training::Utils::Set_OutputPerObject(), add_this = 1;
		else if(strcmp(argv[t],"-learn-edge-model") == 0)
			Training::Utils::SetNoLearnEdgeModel(false), add_this = 1;
		else if(strcmp(argv[t],"-nolearn-edge-model") == 0)
			Training::Utils::SetNoLearnEdgeModel(true), add_this = 1;
		else if(strcmp(argv[t],"-energy-terms") == 0)
			Training::Utils::SetOpt_Using_Exp_EnergyTerm(true), add_this = 1;
		else if(strcmp(argv[t],"-noenergy-terms") == 0)
			Training::Utils::SetOpt_Using_Exp_EnergyTerm(false), add_this = 1;
		else if(strcmp(argv[t],"-no-conserv") == 0)
			Training::Utils::SetOpt_ConservExt(false), add_this = 1;
		else if(strcmp(argv[t],"-no-rg") == 0)
			Training::Utils::SetOpt_Rg(false), add_this = 1;
		else if(strcmp(argv[t],"-no-fe") == 0)
			Training::Utils::SetOpt_Fe(false), add_this = 1;
		else if(strcmp(argv[t],"-no-rasa") == 0)
			Training::Utils::SetOpt_RASAext(false), add_this = 1;
		else if(strcmp(argv[t],"-no-pssm") == 0)
			Training::Utils::SetOpt_PssmExt(false), add_this = 1;
		else if(strcmp(argv[t],"-bin-features") == 0)
			Training::Utils::SetOpt_BinFeatures(true), add_this = 1;
		else if(strcmp(argv[t],"-nobin-features") == 0)
			Training::Utils::SetOpt_BinFeatures(false), add_this = 1;
		else if(strcmp(argv[t],"-set-weight-tozero-if-negative") == 0)
			Training::Utils::SetOpt_SetWeightZero_iff_Negative(true), add_this = 1;
		else if(strcmp(argv[t],"-noset-weight-tozero-if-negative") == 0)
			Training::Utils::SetOpt_SetWeightZero_iff_Negative(false), add_this = 1;
		else if(strcmp(argv[t],"-no-epros") == 0)
			Training::Utils::SetOpt_Epros(false), add_this = 1;
		else if(strcmp(argv[t],"-infer-with-gibbs") == 0)
			Training::Utils::SetOpt_InferWithGibbs(true), add_this = 1;
    	else if(strcmp(argv[t],"-learn-optfunc") == 0 && t+1<argc) {
    		if(strcmp(argv[t+1],"roc-curve") == 0) {
    			Training::Utils::SetOpt_LearnFunctional_ROCcurve();
    			add_this = 2;
    		} else if(strcmp(argv[t+1],"roc-diff") == 0) {
    			Training::Utils::SetOpt_LearnFunctional_ROCdiff();
    			add_this = 2;
    		} else {
    			 if(strcmp(argv[t+1],"roc-set-1") == 0 && t+3<argc) {
					alpha = strtod(argv[t+2],NULL);
					beta = strtod(argv[t+3],NULL);
					Training::Utils::SetOpt_LearnFunctional_ROCset_1(alpha,beta);
					add_this = 4;
    			 } else if(strcmp(argv[t+1],"roc-set-2") == 0 && t+3<argc) {
 					alpha = strtod(argv[t+2],NULL);
 					beta = strtod(argv[t+3],NULL);
 					Training::Utils::SetOpt_LearnFunctional_ROCset_2(alpha,beta);
 					add_this = 4;
     			 } else
    				 usage(argv[t+1]);
    		}
       	} else if(strcmp(argv[t],"-fp-scale") == 0 && t+1<argc) {
    		alpha = strtod(argv[t+1],NULL);
    		Training::Utils::SetOpt_FP_Scale_inOLM(alpha);
    		add_this = 2;
       	} else if(strcmp(argv[t],"-fn-scale") == 0 && t+1<argc) {
    		alpha = strtod(argv[t+1],NULL);
    		Training::Utils::SetOpt_FN_Scale_inOLM(alpha);
    		add_this = 2;
       	} else if(strcmp(argv[t],"-edge-model") == 0 && t+2<argc) {
    		alpha = strtod(argv[t+1],NULL);
    		beta = strtod(argv[t+2],NULL);
    		Training::Utils::SetEdgeModel(alpha,beta);
    		add_this = 3;
    	} else if(strcmp(argv[t],"-intermediates") == 0 && t+1<argc) {
    		no = strtoul(argv[t+1],NULL,0);
    		Training::Utils::SetIntermediates(no);
    		add_this = 2;
    	} else if(strcmp(argv[t],"-steps-per-sample") == 0 && t+1<argc) {
    		no = strtoul(argv[t+1],NULL,0);
    		Training::Utils::SetMaxLearnStepsPerSample(no);
    		add_this = 2;
    	} else if(strcmp(argv[t],"-config-rg-data") == 0 && t+1<argc) {
    		bool which = (strcmp("data",argv[t+1]) == 0);
    		Training::Utils::SetOpt_Rg_CfgData(which);
    		add_this = 2;
    	} else if(strcmp(argv[t],"-learn-chunksize") == 0 && t+1<argc) {
    		no = strtoul(argv[t+1],NULL,0);
    		Training::Utils::SetChunkSize(no);
    		add_this = 2;
    	} else if(strcmp(argv[t],"-learnrounds-oninput") == 0 && t+1<argc) {
			no = strtoul(argv[t+1],NULL,0);
			Training::Utils::SetLearnRounds_PerInput(no), add_this = 2;
    	} else if(strcmp(argv[t],"-log-dir") == 0 && t+1<argc)
    		logdir = argv[t+1], add_this = 2;
    	else if(strcmp(argv[t],"-no-logdomain") == 0)
    		Training::Utils::SetRun_InLogDomain(false), add_this = 1;
    	else if(strcmp(argv[t],"-output-dir") == 0 && t+1<argc)
    		Training::Utils::Set_DataOutputDIR(argv[t+1]), add_this = 2;
		else
            usage(argv[t]);
    }
    if(more_verbose) {
    	printf("Supplied command line\n");
    	for(t=1; t < argc; t++) {
    		printf(" -- %s.\n",argv[t]);
    	}
    	printf("\n");
    }
	if(cmd != Training::Types::Cmd_Idle) {
		Log::get()->init_logs(logdir);
		Training::Utils::Run(cmd);
		Log::get()->end_logs();
	} else
		usage("No command given.");

	return 0;
}
