/*
 * 	train_types.h
 *
 *  Created on: 16 June 2011
 *      Author: torsten
 */

#ifndef TRAIN_TYPES_H_
#define TRAIN_TYPES_H_

#ifndef	_SYS_TYPES_H
#include <sys/types.h>
#endif // _SYS_TYPES_H

#ifndef _GLIBCXX_STRING
#include <string>
#endif // _GLIBCXX_STRING

#ifndef _GLIBCXX_FUNCTIONAL
#include <functional>
#endif // _GLIBCXX_FUNCTIONAL

#ifndef _GLIBCXX_VECTOR
#include <vector>
#endif // _GLIBCXX_VECTOR

#ifndef	_ASSERT_H
#include <assert.h>
#endif // _ASSERT_H

#ifndef GRAPH_TYPES_H_
#include <graph_types.h>
#endif // GRAPH_TYPES_H_

#ifndef	_STRING_H
#include <string.h>
#endif // _STRING_H


namespace std { using namespace __gnu_cxx; }

namespace	Training	{

namespace	Types	{

		enum	Cmd	{
			Cmd_Idle		=	0,
			Cmd_Learn		=	1,
			Cmd_Validate	=	2,
			Cmd_Classify	=	3,
			Cmd_Parse		=	4,
			Cmd_ModelGraphs =	5
		};

	struct	Node	{
		/* Configuration Weight vector for nodes weights, initial nodes weights etc.
		 */
		enum	StateBinFeature	{
			StateBinFeature_StateNumber			=	2,

			StateBinFeature_FeatureNumber		=	12,

			StateBinFeature_Feature_RASA_if		=	1,
			StateBinFeature_Feature_RASAnoif	=	2,

			StateBinFeature_Feature_PSSM_if		=	3,
			StateBinFeature_Feature_PSSMnoif	=	4,

			StateBinFeature_Feature_CON_if		=	5,
			StateBinFeature_Feature_CON_noif	=	6,

			StateBinFeature_Feature_Epros_if	=	7,
			StateBinFeature_Feature_Epros_noif	=	8,

			StateBinFeature_Feature_Rg_if		=	9,
			StateBinFeature_Feature_Rg_noif		=	10,

			StateBinFeature_Feature_Fe_if		=	11,
			StateBinFeature_Feature_Fe_noif		=	12
		};

		enum	RefLabel	{
			RefLabel_NoIf	=	0,
			RefLabel_If		=	1
		};

		enum	ScorePssm	{
			ScorePssm_If	=	0,
			ScorePssm_NoIf	=	1
		};

		double		m_Score_rASA, m_Score_Conserv, m_Score_PSSM[2], m_Score_Epros, m_Score_Rg, m_Score_Fe;

		std::string	m_Aa_Name;

		double
					m_Conserv_if_win, m_Conserv_noif_win,
					m_RASA_if_win, m_RASA_noif_win,
					m_PSSM_if_win, m_PSSM_noif_win,
					m_EPROS_if_win, m_EPROS_noif_win,
					m_Rg_if, m_Rg_noif,
					m_Fe_if, m_Fe_noif;

		enum	{
			Pssm_Org_Slots	=	15,
			Pssm_Org_CntRes	=	20
		};

	    std::vector<double>
	    			m_Pssm_Org, m_Pssm_OrgAbs;

		RefLabel	m_RefLabel;

		size_t		m_Conserv_if_Slot, m_Conserv_noif_Slot,
					m_RASA_if_Slot, m_RASA_noif_Slot,
					m_PSSM_if_Slot, m_PSSM_noif_Slot,
					m_EPROS_if_Slot, m_EPROS_noif_Slot,
					m_Rg_if_Slot, m_Rg_noif_Slot,
					m_Fe_if_Slot, m_Fe_noif_Slot;

			/* Small energy profile chosen in order to have small prob.val if residue has not epros.val assigned
				prob(epros.max=30) -> 0

				small conservation value assigned if residue has not conserv.val assigned
				prob(conserv.min=-80.0) -> 0

				smallest pssm values assigned in case of residue is not carrying this value in order to get small prob. then
				prob(pssm.max = 96) -> 0

				small rg value assigned if residue has not rg.val assigned
				rg.min= -.10 <--> non interface label

				small fe value assigned if residue has not fe.val assigned
				fe.min= .0 <--> non interface label
				fe.max= .0 <--> interface label

			 */
			Node():m_Score_rASA(0.), m_Score_Conserv(-90.), m_Score_Epros(50.0), m_Aa_Name(), m_RefLabel(RefLabel_NoIf) {
				m_Score_PSSM[0] = m_Score_PSSM[1] = 96.;
				m_Score_Rg = -.1;
				m_RASA_if_win = 0.;
				m_RASA_noif_win = 0.;
				m_PSSM_if_win = 0.;
				m_PSSM_noif_win = 0.;
				m_EPROS_if_win = 0.;
				m_EPROS_noif_win = 0.;
				m_Conserv_if_win = 0.;
				m_Conserv_noif_win = 0.;
				m_Conserv_if_Slot = m_Conserv_noif_Slot = 0;
				m_RASA_if_Slot = m_RASA_noif_Slot = 0;
				m_PSSM_if_Slot = m_PSSM_noif_Slot = 0;
				m_EPROS_if_Slot = m_EPROS_noif_Slot = 0;

				m_Rg_if_Slot = m_Rg_noif_Slot = 0;
				m_Rg_if = m_Rg_noif = 0;

				m_Pssm_Org.clear();
				m_Pssm_OrgAbs.clear();

				m_Score_Fe = 0.;
				m_Fe_if_Slot = m_Fe_noif_Slot = 0;
				m_Fe_if = m_Fe_noif = 0;
			}

			Node(const Node& r) {
				operator=(r);
			}

			Node&
			operator=(const Node& r) {
				if(this != &r) {
					m_Score_rASA = r.m_Score_rASA;
					m_Score_Epros = r.m_Score_Epros;
					m_Score_Rg = r.m_Score_Rg;
					m_Score_Fe = r.m_Score_Fe;
					m_Score_Conserv = r.m_Score_Conserv;
					m_Score_PSSM[0] = r.m_Score_PSSM[0];
					m_Score_PSSM[1] = r.m_Score_PSSM[1];
					m_Aa_Name = r.m_Aa_Name;
					m_RefLabel = r.m_RefLabel;
					m_RASA_if_win = r.m_RASA_if_win;
					m_RASA_noif_win = r.m_RASA_noif_win;
					m_PSSM_if_win = r.m_PSSM_if_win;
					m_PSSM_noif_win = r.m_PSSM_noif_win;
					m_Conserv_if_win = r.m_Conserv_if_win;
					m_Conserv_noif_win = r.m_Conserv_noif_win;
					m_EPROS_if_win = r.m_EPROS_if_win;
					m_EPROS_noif_win = r.m_EPROS_noif_win;
					m_Rg_if_Slot = r.m_Rg_if_Slot;
					m_Rg_noif_Slot = r.m_Rg_noif_Slot;
					m_RASA_if_Slot = r.m_RASA_if_Slot;
					m_RASA_noif_Slot = r.m_RASA_noif_Slot;
					m_PSSM_if_Slot = r.m_PSSM_if_Slot;
					m_PSSM_noif_Slot = r.m_PSSM_noif_Slot;
					m_Conserv_if_Slot = r.m_Conserv_if_Slot;
					m_Conserv_noif_Slot = r.m_Conserv_noif_Slot;
					m_EPROS_if_Slot = r.m_EPROS_if_Slot;
					m_EPROS_noif_Slot = r.m_EPROS_noif_Slot;
					m_Rg_if_Slot = r.m_Rg_if_Slot;
					m_Rg_noif_Slot = r.m_Rg_noif_Slot;
					m_Fe_if_Slot = r.m_Fe_if_Slot;
					m_Fe_noif_Slot = r.m_Fe_noif_Slot;

					m_Pssm_Org = r.m_Pssm_Org;
					m_Pssm_OrgAbs = r.m_Pssm_OrgAbs;
				}
				return *this;
			}
	};

	struct
	FindNodeId :   std::unary_function<const GraphGen::Node<Node>&,bool> {

			FindNodeId	(int64_t id):m_Id(id)
	        {  }

	        bool
	        operator()  (const GraphGen::Node<Node>& x)
	        { 	return (x.m_Id == m_Id);		}

	        int64_t m_Id;

	};

	struct Edge	:	public GraphGen::Edge<GraphGen::Node<Node>* > {

		static
		const double
				EdgeModel__gii,
				EdgeModel__gij;

				Edge				():GraphGen::Edge<GraphGen::Node<Node>* >() {
				}

				Edge				(const Edge& e):GraphGen::Edge<GraphGen::Node<Node>* >() {
					operator=(e);
				}

				Edge&
				operator=(const Edge& e) {
					if(this != &e) {
						GraphGen::Edge<GraphGen::Node<Node>* >::operator=(e);
					}
					return *this;
				}
	};

	struct
	FindEdge :   std::unary_function<const Edge&,bool> {

				FindEdge	(int64_t n1, int64_t n2):m_N1(n1), m_N2(n2)
				{  }

				bool
				operator()  (const Edge& e) {
					int64_t n1(e.m_Node_1->m_Id), n2(e.m_Node_2->m_Id);
					return ((n1 == m_N1 || n1 == m_N2) && (n2 == m_N1 || n2 == m_N2));
				}

				int64_t m_N1, m_N2;
	};


} }	// Training::Types

#endif // TRAIN_TYPES_H_

